/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.render;

import baguchi.bagus_lib.client.layer.CustomArmorLayer;
import baguchi.hunters_return.HunterConfig;
import baguchi.hunters_return.client.ModModelLayers;
import baguchi.hunters_return.client.model.HunterModel;
import baguchi.hunters_return.client.model.NewHunterModel;
import baguchi.hunters_return.client.model.OldHunterModel;
import baguchi.hunters_return.client.render.layer.MouthItemLayer;
import baguchi.hunters_return.client.render.state.HunterRenderState;
import baguchi.hunters_return.entity.Hunter;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.illager.AbstractIllager;

public class HunterRender
extends MobRenderer<Hunter, HunterRenderState, HunterModel<HunterRenderState>> {
    private static final Identifier ILLAGER = Identifier.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/hunter.png");
    private static final Identifier ILLAGER_OLD = Identifier.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/normal_old.png");
    private static final RenderType SLEEP_EYE = RenderTypes.entityCutoutNoCull((Identifier)Identifier.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/sleep_eye.png"));
    private static final RenderType SLEEP_EYE_OLD = RenderTypes.entityCutoutNoCull((Identifier)Identifier.fromNamespaceAndPath((String)"hunters_return", (String)"textures/entity/hunter/sleep_eye_old.png"));
    private final HunterModel<HunterRenderState> old;
    private final HunterModel<HunterRenderState> normal;

    public HunterRender(EntityRendererProvider.Context context) {
        super(context, new NewHunterModel(context.bakeLayer(ModModelLayers.HUNTER)), 0.5f);
        this.addLayer((RenderLayer)new CustomArmorLayer((RenderLayerParent)this, context));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer(new MouthItemLayer(this));
        this.addLayer((RenderLayer)new EyesLayer<HunterRenderState, HunterModel<HunterRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack p_116983_, SubmitNodeCollector p_116984_, int p_116985_, HunterRenderState p_363277_, float p_116987_, float p_116988_) {
                float f3 = p_363277_.ageInTicks + (float)p_363277_.id;
                if (!p_363277_.isInvisible && (0.0 > Math.sin(f3 * 0.05f) + Math.sin(f3 * 0.13f) + Math.sin(f3 * 0.7f) + (double)2.55f || p_363277_.sleep)) {
                    super.submit(p_116983_, p_116984_, p_116985_, (EntityRenderState)p_363277_, p_116987_, p_116988_);
                }
            }

            public RenderType renderType() {
                if (((Boolean)HunterConfig.CLIENT.oldModel.get()).booleanValue()) {
                    return SLEEP_EYE_OLD;
                }
                return SLEEP_EYE;
            }
        });
        this.old = new OldHunterModel<HunterRenderState>(context.bakeLayer(ModModelLayers.HUNTER_OLD));
        this.normal = new NewHunterModel<HunterRenderState>(context.bakeLayer(ModModelLayers.HUNTER));
    }

    public void submit(HunterRenderState p_433493_, PoseStack p_434615_, SubmitNodeCollector p_433768_, CameraRenderState p_450931_) {
        super.submit((LivingEntityRenderState)p_433493_, p_434615_, p_433768_, p_450931_);
        this.model = (Boolean)HunterConfig.CLIENT.oldModel.get() != false ? this.old : this.normal;
    }

    public HunterRenderState createRenderState() {
        return new HunterRenderState();
    }

    public void extractRenderState(Hunter hunter, HunterRenderState hunterState, float p_361157_) {
        super.extractRenderState((LivingEntity)hunter, (LivingEntityRenderState)hunterState, p_361157_);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)hunter, (ArmedEntityRenderState)hunterState, (ItemModelResolver)this.itemModelResolver, (float)p_361157_);
        HunterRenderState.extractMouthEntityRenderState(hunter, hunterState, this.itemModelResolver);
        hunterState.isRiding = hunter.isPassenger();
        hunterState.mainArm = hunter.getMainArm();
        hunterState.armPose = hunter.getArmPose();
        hunterState.maxCrossbowChargeDuration = hunterState.armPose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE ? hunter.getUseItem().getUseDuration((LivingEntity)hunter) : 0;
        hunterState.ticksUsingItem = hunter.getTicksUsingItem();
        hunterState.attackAnim = hunter.getAttackAnim(p_361157_);
        hunterState.isAggressive = hunter.isAggressive();
        hunterState.attackAnimationState.copyFrom(hunter.attackAnimationState);
        hunterState.chargeAnimationState.copyFrom(hunter.chargeAnimationState);
        hunterState.shootAnimationState.copyFrom(hunter.shootAnimationState);
        hunterState.thrownAnimationState.copyFrom(hunter.thrownAnimationState);
        hunterState.dodghRightAnimationState.copyFrom(hunter.dodghRightAnimationState);
        hunterState.dodghLeftAnimationState.copyFrom(hunter.dodghLeftAnimationState);
        hunterState.texture = hunter.getTexture();
        hunterState.textureOld = hunter.getTextureOld();
        hunterState.eyeRot = hunter.getViewYRot(p_361157_) - hunter.getPreciseBodyRotation(p_361157_) + 180.0f;
        hunterState.sleep = hunter.isSleeping();
        hunterState.id = hunter.getId();
    }

    public Identifier getTextureLocation(HunterRenderState hunterRenderState) {
        if (((Boolean)HunterConfig.CLIENT.oldModel.get()).booleanValue()) {
            if (hunterRenderState.textureOld != null) {
                return hunterRenderState.textureOld;
            }
            return ILLAGER_OLD;
        }
        if (hunterRenderState.texture != null) {
            return hunterRenderState.texture;
        }
        return ILLAGER;
    }
}

