/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;

public class ModelRegistry {
    public static void onModelRegister(ModelEvent.RegisterStandalone event) {
        for (Model model : Model.values()) {
            event.register(model.getModelKey(), (UnbakedStandaloneModel)new SimpleUnbakedStandaloneModel(model.resource, (resolvedModel, baker) -> {
                ResolvedModel resolvedmodel = baker.getModel(model.getIdentifier());
                TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
                return resolvedModel.bakeTopGeometry(textureslots, baker, (ModelState)BlockModelRotation.IDENTITY);
            }));
        }
    }

    public static void onModelBake(ModelEvent.BakingCompleted event) {
        for (Model model : Model.values()) {
            QuadCollection quads = (QuadCollection)event.getBakingResult().standaloneModels().get(model.getModelKey());
            if (quads == null) continue;
            model.getModel().set(quads);
        }
    }

    public static enum Model {
        ENERGY_PIPE_EXTRACT(Identifier.fromNamespaceAndPath((String)"pipez", (String)"block/energy_pipe_extract")),
        FLUID_PIPE_EXTRACT(Identifier.fromNamespaceAndPath((String)"pipez", (String)"block/fluid_pipe_extract")),
        GAS_PIPE_EXTRACT(Identifier.fromNamespaceAndPath((String)"pipez", (String)"block/gas_pipe_extract")),
        ITEM_PIPE_EXTRACT(Identifier.fromNamespaceAndPath((String)"pipez", (String)"block/item_pipe_extract")),
        UNIVERSAL_PIPE_EXTRACT(Identifier.fromNamespaceAndPath((String)"pipez", (String)"block/universal_pipe_extract"));

        private final Identifier resource;
        private final StandaloneModelKey<QuadCollection> modelKey;
        private final AtomicReference<QuadCollection> model;

        private Model(Identifier rl) {
            this.resource = rl;
            this.modelKey = new StandaloneModelKey(() -> ((Identifier)rl).toString());
            this.model = new AtomicReference();
        }

        public Identifier getIdentifier() {
            return this.resource;
        }

        public StandaloneModelKey<QuadCollection> getModelKey() {
            return this.modelKey;
        }

        public AtomicReference<QuadCollection> getModel() {
            return this.model;
        }
    }
}

