/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.PipezMod;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.datacomponents.ItemData;
import de.maxhenkel.pipez.items.ModItems;
import de.maxhenkel.pipez.utils.ComponentUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;

public class ItemPipeType
extends PipeType<Item, ItemData> {
    public static final ItemPipeType INSTANCE = new ItemPipeType();
    private static final ItemData DEFAULT = new ItemData(UpgradeTileEntity.FilterMode.WHITELIST, UpgradeTileEntity.RedstoneMode.IGNORED, UpgradeTileEntity.Distribution.NEAREST, Collections.emptyList());

    @Override
    public BlockCapability<?, Direction> getCapability() {
        return Capabilities.Item.BLOCK;
    }

    @Override
    public Filter<?, Item> createFilter() {
        return new ItemFilter();
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.NEAREST;
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.item";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.ITEM_PIPE.get());
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return Component.translatable((String)"tooltip.pipez.rate.item", (Object[])new Object[]{this.getRate(upgrade), this.getSpeed(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            ResourceHandler<ItemResource> itemHandler;
            PipeTileEntity.Connection extractingConnection;
            if (tileEntity.getLevel().getGameTime() % (long)this.getSpeed(tileEntity, side) != 0L || !tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (extractingConnection = tileEntity.getExtractingConnection(side)) == null || (itemHandler = extractingConnection.getItemHandler()) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, itemHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, itemHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, ResourceHandler<ItemResource> itemHandler) {
        if (connections.isEmpty()) {
            return;
        }
        int itemsToTransfer = this.getRate(tileEntity, side);
        boolean[] inventoriesFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (itemsToTransfer > 0 && this.hasNotInserted(inventoriesFull)) {
            int moved;
            PipeTileEntity.Connection connection = connections.get(p);
            ResourceHandler<ItemResource> destination = connection.getItemHandler();
            boolean hasInserted = false;
            if (destination != null && !inventoriesFull[p] && !ResourceHandlerUtil.isFull(destination) && (moved = ResourceHandlerUtil.move(itemHandler, destination, resource -> this.canInsert((HolderLookup.Provider)tileEntity.getLevel().registryAccess(), connection, resource.toStack(), tileEntity.getFilters(side, this)) != tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST), (int)1, null)) > 0) {
                hasInserted = true;
                itemsToTransfer -= moved;
            }
            if (!hasInserted) {
                inventoriesFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, ResourceHandler<ItemResource> itemHandler) {
        int moved;
        PipeTileEntity.Connection connection;
        ResourceHandler<ItemResource> destination;
        int itemsToTransfer = this.getRate(tileEntity, side);
        Iterator<PipeTileEntity.Connection> iterator = connections.iterator();
        while (iterator.hasNext() && ((destination = (connection = iterator.next()).getItemHandler()) == null || ResourceHandlerUtil.isFull(destination) || (itemsToTransfer -= (moved = ResourceHandlerUtil.move(itemHandler, destination, resource -> this.canInsert((HolderLookup.Provider)tileEntity.getLevel().registryAccess(), connection, resource.toStack(), tileEntity.getFilters(side, this)) != tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST), (int)itemsToTransfer, null))) > 0)) {
        }
    }

    private boolean canInsert(HolderLookup.Provider provider, PipeTileEntity.Connection connection, ItemStack stack, List<Filter<?, ?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(provider, filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(provider, filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(HolderLookup.Provider provider, Filter<?, Item> filter, ItemStack stack) {
        CompoundTag metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || filter.getTag().contains(stack.getItem());
        }
        CompoundTag stackNBT = ComponentUtils.getTag(provider, stack);
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((Tag)metadata, (Tag)stackNBT)) {
                return filter.getTag() == null || filter.getTag().contains(stack.getItem());
            }
            return false;
        }
        if (stackNBT.isEmpty()) {
            return metadata.size() <= 0;
        }
        if (!this.deepFuzzyCompare((Tag)metadata, (Tag)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || filter.getTag().contains(stack.getItem());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    public int getSpeed(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getSpeed(tileEntity.getUpgrade(direction));
    }

    public int getSpeed(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)PipezMod.SERVER_CONFIG.itemPipeSpeed.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeSpeedBasic.get();
            }
            case IMPROVED: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeSpeedImproved.get();
            }
            case ADVANCED: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeSpeedAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeSpeedUltimate.get();
            }
        }
        return 1;
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)PipezMod.SERVER_CONFIG.itemPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)PipezMod.SERVER_CONFIG.itemPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public DataComponentType<ItemData> getDataComponentType() {
        return (DataComponentType)ModItems.ITEM_DATA_COMPONENT.get();
    }

    @Override
    public ItemData defaultData() {
        return DEFAULT;
    }
}

