/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.CachedMap;
import de.maxhenkel.pipez.corelib.FontColorUtils;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedItemStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.gui.ExtractScreen;
import de.maxhenkel.pipez.gui.WidgetBase;
import de.maxhenkel.pipez.utils.ComponentUtils;
import de.maxhenkel.pipez.utils.MekanismUtils;
import de.maxhenkel.pipez.utils.WrappedGasStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FilterList
extends WidgetBase {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"pipez", (String)"textures/gui/container/extract.png");
    protected Supplier<List<Filter<?, ?>>> filters;
    protected int offset;
    protected int selected;
    private ScreenBase.HoverArea[] hoverAreas;
    private ScreenBase.HoverArea[] itemHoverAreas;
    private ScreenBase.HoverArea[] blockHoverAreas;
    private int columnHeight;
    private int columnCount;
    private CachedMap<DirectionalPosition, Pair<BlockState, ItemStack>> filterPosCache;

    public FilterList(ExtractScreen screen, int posX, int posY, int xSize, int ySize, Supplier<List<Filter<?, ?>>> filters) {
        super(screen, posX, posY, xSize, ySize);
        this.filters = filters;
        this.columnHeight = 22;
        this.columnCount = 3;
        this.selected = -1;
        this.hoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.itemHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.blockHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new ScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
            this.itemHoverAreas[i] = new ScreenBase.HoverArea(3, 3 + i * this.columnHeight, 16, 16);
            this.blockHoverAreas[i] = new ScreenBase.HoverArea(xSize - 3 - 16 - 11, 3 + i * this.columnHeight, 16, 16);
        }
        this.filterPosCache = new CachedMap(1000L);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        List<Filter<?, ?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            Filter<?, ?> filter = f.get(this.getOffset() + i);
            if (this.itemHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                AbstractStack<?> stack = FilterList.getStack(filter);
                if (stack == null || stack.isEmpty()) continue;
                List<Component> tooltip = stack.getTooltip();
                if (filter.isInvert()) {
                    tooltip.set(0, (Component)Component.translatable((String)"tooltip.pipez.filter.not").withStyle(ChatFormatting.DARK_RED).append(" ").append(tooltip.get(0)));
                }
                if (filter.getTag() != null && !(filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.pipez.filter.accepts_tag", (Object[])new Object[]{Component.literal((String)filter.getTag().getName().toString()).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
                }
                guiGraphics.setTooltipForNextFrame(this.mc.font, tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList()), mouseX, mouseY);
                continue;
            }
            if (!this.blockHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) || filter.getDestination() == null) continue;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            Pair<BlockState, ItemStack> destPair = this.getBlockAt(filter.getDestination());
            if (destPair.getKey() == null) {
                tooltip.add(net.minecraft.network.chat.ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"tooltip.pipez.filter.unknown_block")).withStyle(ChatFormatting.DARK_RED));
            } else {
                tooltip.add(destPair.getKey().getBlock().getName().withStyle(ChatFormatting.BLUE));
            }
            BlockPos pos = filter.getDestination().getPos();
            tooltip.add(Component.translatable((String)"tooltip.pipez.filter.destination_location", (Object[])new Object[]{this.number(pos.getX()), this.number(pos.getY()), this.number(pos.getZ())}));
            tooltip.add(Component.translatable((String)"tooltip.pipez.filter.destination_distance", (Object[])new Object[]{this.number(pos.distManhattan((Vec3i)this.getContainer().getPipe().getBlockPos()))}));
            tooltip.add(Component.translatable((String)"tooltip.pipez.filter.destination_side", (Object[])new Object[]{Component.translatable((String)("message.pipez.direction." + filter.getDestination().getDirection().getName())).withStyle(ChatFormatting.DARK_GREEN)}));
            guiGraphics.setTooltipForNextFrame(this.mc.font, tooltip.stream().map(Component::getVisualOrderText).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    private MutableComponent number(int num) {
        return Component.literal((String)String.valueOf(num)).withStyle(ChatFormatting.DARK_GREEN);
    }

    @Nullable
    public static AbstractStack<?> getStack(Filter<?, ?> filter) {
        WrappedGasStack gasStack;
        Object o = null;
        if (filter.getTag() != null) {
            o = FilterList.get(filter.getTag());
        }
        if (o instanceof Item) {
            ItemStack stack = new ItemStack((ItemLike)((Item)o));
            if (filter.getMetadata() != null) {
                stack.applyComponents(ComponentUtils.getPatch((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (Tag)filter.getMetadata().copy()));
            }
            return new WrappedItemStack(stack);
        }
        if (o instanceof Fluid) {
            FluidStack stack = new FluidStack((Fluid)o, 1000);
            if (filter.getMetadata() != null) {
                stack.applyComponents(ComponentUtils.getPatch((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (Tag)filter.getMetadata().copy()));
            }
            return new WrappedFluidStack(stack);
        }
        if (MekanismUtils.isMekanismInstalled() && (gasStack = WrappedGasStack.dummyStack(o)) != null) {
            return gasStack;
        }
        return null;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        List<Filter<?, ?>> f = this.filters.get();
        for (int i = this.getOffset(); i < f.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            Filter<?, ?> filter = f.get(i);
            if (i == this.getSelected()) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.guiLeft, startY, 0.0f, 218.0f, 125, this.columnHeight, 256, 256);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.guiLeft, startY, 0.0f, 196.0f, 125, this.columnHeight, 256, 256);
            }
            AbstractStack<?> stack = FilterList.getStack(filter);
            if (stack != null && !stack.isEmpty()) {
                stack.render(guiGraphics, this.guiLeft + 3, startY + 3);
                if (filter.getTag() != null) {
                    if (filter.getTag() instanceof SingleElementTag) {
                        this.drawStringSmall(guiGraphics, this.guiLeft + 22, startY + 5, (Component)Component.translatable((String)"message.pipez.filter.item", (Object[])new Object[]{Component.translatable((String)stack.getDisplayName().getString()).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.WHITE));
                    } else {
                        this.drawStringSmall(guiGraphics, this.guiLeft + 22, startY + 5, (Component)Component.translatable((String)"message.pipez.filter.tag", (Object[])new Object[]{Component.literal((String)filter.getTag().getName().toString()).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.WHITE));
                    }
                }
            } else {
                this.drawStringSmall(guiGraphics, this.guiLeft + 22, startY + 5, (Component)Component.translatable((String)"message.pipez.filter.any_item").withStyle(ChatFormatting.WHITE));
            }
            if (filter.getMetadata() != null && filter.getMetadata().size() > 0) {
                MutableComponent tags = Component.translatable((String)("message.pipez.filter.nbt.tag" + (filter.getMetadata().size() != 1 ? "s" : "")), (Object[])new Object[]{filter.getMetadata().size()}).withStyle(ChatFormatting.DARK_PURPLE);
                MutableComponent nbtStr = Component.translatable((String)"message.pipez.filter.nbt", (Object[])new Object[]{tags}).withStyle(ChatFormatting.WHITE);
                if (filter.isExactMetadata()) {
                    nbtStr.append(" ").append((Component)Component.translatable((String)"message.pipez.filter.nbt.exact"));
                }
                this.drawStringSmall(guiGraphics, this.guiLeft + 22, startY + 10, (Component)nbtStr);
            }
            if (filter.isInvert()) {
                this.drawStringSmall(guiGraphics, this.guiLeft + 22, startY + 15, (Component)Component.translatable((String)"message.pipez.filter.inverted").withStyle(ChatFormatting.DARK_RED));
            }
            if (filter.getDestination() == null) continue;
            Pair<BlockState, ItemStack> dstPair = this.getBlockAt(filter.getDestination());
            guiGraphics.renderItem(dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3, 0);
            guiGraphics.renderItemDecorations(this.mc.font, dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3, String.valueOf(filter.getDestination().getDirection().name().charAt(0)));
        }
        if (f.size() > this.columnCount) {
            float h = 49.0f;
            float perc = (float)this.getOffset() / (float)(f.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.guiLeft + this.xSize - 10, posY, 125.0f, 196.0f, 10, 17, 256, 256);
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.guiLeft + this.xSize - 10, this.guiTop, 135.0f, 196.0f, 10, 17, 256, 256);
        }
    }

    private Pair<BlockState, ItemStack> getBlockAt(DirectionalPosition destination) {
        return this.filterPosCache.get(destination, () -> {
            ItemStack pickBlock;
            ItemStack stack = new ItemStack((ItemLike)Items.WHITE_CONCRETE);
            BlockState state = null;
            if (this.mc.level.isAreaLoaded(destination.getPos(), 1) && (pickBlock = (state = this.mc.level.getBlockState(destination.getPos())).getBlock().getCloneItemStack((LevelReader)this.mc.level, destination.getPos(), state, true, (Player)this.mc.player)) != null && !pickBlock.isEmpty()) {
                stack = pickBlock;
            }
            return new Pair<Object, ItemStack>(state, stack);
        });
    }

    @Override
    public void tick() {
        super.tick();
        this.filterPosCache.clear();
    }

    public int getOffset() {
        List<Filter<?, ?>> f = this.filters.get();
        if (f.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > f.size() - this.columnCount) {
            this.offset = f.size() - this.columnCount;
        }
        return this.offset;
    }

    public int getSelected() {
        if (this.selected >= this.filters.get().size()) {
            this.selected = -1;
        }
        return this.selected;
    }

    private void drawStringSmall(GuiGraphics guiGraphics, int x, int y, Component text) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y);
        guiGraphics.pose().scale(0.5f, 0.5f);
        guiGraphics.drawString(this.mc.font, text, 0, 0, FontColorUtils.BLACK, false);
        guiGraphics.pose().popMatrix();
    }

    @Nullable
    public static <T> T get(de.maxhenkel.pipez.corelib.tag.Tag<T> tag) {
        long time = Minecraft.getInstance().level.getGameTime();
        List allElements = tag.getAll().stream().toList();
        if (allElements.isEmpty()) {
            return null;
        }
        return (T)allElements.get((int)(time / 20L % (long)allElements.size()));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        List<Filter<?, ?>> f = this.filters.get();
        if (f.size() > this.columnCount) {
            this.offset = deltaY < 0.0 ? Math.min(this.getOffset() + 1, f.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean b) {
        List<Filter<?, ?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)event.x(), (int)event.y())) continue;
            this.selected = this.getOffset() + i;
            return true;
        }
        return super.mouseClicked(event, b);
    }
}

