/*
 * Decompiled with CFR 0.152.
 */
package client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="jeb", value={Dist.CLIENT})
public class JebClient {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"JEB");
    public static Set<Item> existingResultItems = new HashSet<Item>();
    public static Set<Item> nonexistingResultItems = new HashSet<Item>();
    public static String string = "-";
    public static List<RecipeCollection> filtered = new ArrayList<RecipeCollection>();
    public static List<RecipeCollection> emptysearch = new ArrayList<RecipeCollection>();
    public static boolean recipesLoaded = false;
    public static boolean customToggleEnabled = true;
    public static List<RecipeCollection> PREGENERATED_RECIPES;
    public static Path CONFIG_PATH;
    private static final Gson GSON;
    static KeyMapping keyBinding;
    public static KeyMapping keyBinding2;
    private static final KeyMapping.Category JEB_CATEGORY;

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        keyBinding = new KeyMapping("key.jeb.optional_recipes_loading_screen", 39, JEB_CATEGORY);
        event.register(keyBinding);
        keyBinding2 = new KeyMapping("key.jeb.add_remove_favorite_recipes", 65, JEB_CATEGORY);
        event.register(keyBinding2);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PREGENERATED_RECIPES = JebClient.generateCustomRecipeList("");
        CONFIG_PATH = Paths.get(Minecraft.getInstance().gameDirectory.getAbsolutePath(), "config", "JEB.json");
        JebClient.loadConfig();
    }

    public static void loadConfig() {
        block8: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json.has("customToggleEnabled")) {
                        customToggleEnabled = json.get("customToggleEnabled").getAsBoolean();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("customToggleEnabled", Boolean.valueOf(customToggleEnabled));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<RecipeCollection> generateCustomRecipeList(String filter) {
        ArrayList<RecipeCollection> result = new ArrayList<RecipeCollection>();
        Minecraft client = Minecraft.getInstance();
        String query = "";
        String modName = null;
        if (filter.startsWith("@")) {
            int endIndex = filter.indexOf(" ");
            if (endIndex != -1) {
                modName = filter.substring(1, endIndex).trim();
                query = filter.substring(endIndex + 1).toLowerCase(Locale.ROOT);
            } else {
                modName = filter.substring(1).trim();
            }
        } else {
            query = filter.toLowerCase(Locale.ROOT);
        }
        TooltipFlag.Default tooltipFlag = client.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        for (Item item : nonexistingResultItems) {
            boolean matches;
            if (item == Items.AIR || modName != null && !modName.isEmpty() && !BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().contains(modName.toLowerCase(Locale.ROOT))) continue;
            String name = item.getName().getString().toLowerCase(Locale.ROOT);
            String idString = item.toString().toLowerCase(Locale.ROOT);
            String key = "";
            Component nameComponent = item.getName();
            ComponentContents componentContents = nameComponent.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                key = translatable.getKey().toLowerCase(Locale.ROOT);
            }
            boolean bl = matches = query.isEmpty() || name.contains(query) || idString.contains(query) || key.contains(query);
            if (!matches && query.length() >= 3 && client.level != null) {
                try {
                    List tooltip = item.getDefaultInstance().getTooltipLines(Item.TooltipContext.of((Level)client.level), (Player)client.player, (TooltipFlag)tooltipFlag);
                    for (Component line : tooltip) {
                        String clean = ChatFormatting.stripFormatting((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                        if (!clean.contains(query)) continue;
                        matches = true;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!matches) continue;
            result.add(JebClient.createDummyRecipeCollection(item));
        }
        return result;
    }

    private static RecipeCollection createDummyRecipeCollection(Item item) {
        Identifier id = BuiltInRegistries.ITEM.getKey((Object)item);
        RecipeDisplayId recipeId = new RecipeDisplayId(9999);
        List<SlotDisplay.TagSlotDisplay> slots = List.of(new SlotDisplay.TagSlotDisplay(TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)id.getPath()))));
        SlotDisplay.ItemStackSlotDisplay resultSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)item, 1));
        Item ct = (Item)BuiltInRegistries.ITEM.getValue(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"crafting_table"));
        SlotDisplay.ItemStackSlotDisplay stationSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)ct));
        List<Ingredient> ingredients = List.of(Ingredient.of((ItemLike)item));
        ShapelessCraftingRecipeDisplay display = new ShapelessCraftingRecipeDisplay(slots, (SlotDisplay)resultSlot, (SlotDisplay)stationSlot);
        OptionalInt group = OptionalInt.empty();
        RecipeBookCategory category = RecipeBookCategories.CRAFTING_MISC;
        RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
        return new RecipeCollection(List.of(entry));
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        JEB_CATEGORY = new KeyMapping.Category(Identifier.fromNamespaceAndPath((String)"jeb", (String)"main"));
    }
}

