/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.JebClient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeIndex {
    public final Map<RecipeBookCategory, Map<String, List<RecipeCollection>>> byResult = new HashMap<RecipeBookCategory, Map<String, List<RecipeCollection>>>();
    public final Map<RecipeBookCategory, Map<String, List<RecipeCollection>>> byMod = new HashMap<RecipeBookCategory, Map<String, List<RecipeCollection>>>();
    public final Map<RecipeBookCategory, Map<String, List<RecipeCollection>>> byIngredientWord = new HashMap<RecipeBookCategory, Map<String, List<RecipeCollection>>>();
    public final Map<RecipeBookCategory, Map<String, List<RecipeCollection>>> byTooltipWord = new HashMap<RecipeBookCategory, Map<String, List<RecipeCollection>>>();
    public final Map<RecipeBookCategory, Set<RecipeCollection>> allCollections = new HashMap<RecipeBookCategory, Set<RecipeCollection>>();
    public static final Map<RecipeBookCategory, Map<Item, RecipeCollection>> GLOBAL_COLLECTIONS_BY_RESULT = new HashMap<RecipeBookCategory, Map<Item, RecipeCollection>>();
    public static final RecipeIndex GLOBAL_RECIPE_INDEX = new RecipeIndex();
    public static boolean jebIndexReady = false;
    public static List<IndexedItem> ITEM_INDEX = new ArrayList<IndexedItem>();

    public static void buildRecipeIndex() {
        long startTime = System.currentTimeMillis();
        JebClient.LOGGER.info("[JEB] buildRecipeIndex started at {}", (Object)new Date(startTime));
        jebIndexReady = false;
        Minecraft client = Minecraft.getInstance();
        ClientRecipeBook book = client.player.getRecipeBook();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.clear();
        GLOBAL_COLLECTIONS_BY_RESULT.clear();
        ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        ArrayList<RecipeBookCategory> allCategories = new ArrayList<RecipeBookCategory>();
        for (Field field : RecipeBookCategories.class.getFields()) {
            if (field.getType() != RecipeBookCategory.class) continue;
            try {
                RecipeBookCategory category = (RecipeBookCategory)field.get(null);
                allCategories.add(category);
            }
            catch (Exception category) {
                // empty catch block
            }
        }
        int totalIndexedRecipes = 0;
        for (RecipeBookCategory category : allCategories) {
            List collections = book.getCollection((ExtendedRecipeBookCategory)category);
            if (collections.isEmpty()) continue;
            Map collectionsByResult = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
            LinkedHashSet<RecipeCollection> categoryCollections = new LinkedHashSet<RecipeCollection>();
            HashMap<String, List> resultIndex = new HashMap<String, List>();
            HashMap<String, List> modIndex = new HashMap<String, List>();
            HashMap<String, List> ingredientIndex = new HashMap<String, List>();
            HashMap<String, List> tooltipIndex = new HashMap<String, List>();
            for (RecipeCollection collection : collections) {
                List entries = collection.getRecipes();
                for (RecipeDisplayEntry recipe : entries) {
                    Optional opt;
                    ++totalIndexedRecipes;
                    ItemStack result = recipe.display().result().resolveForFirstStack(context);
                    if (result == null || result.isEmpty()) continue;
                    Item resultItem = result.getItem();
                    RecipeCollection realCollection = (RecipeCollection)collectionsByResult.get(resultItem);
                    if (realCollection == null) {
                        realCollection = new RecipeCollection(new ArrayList());
                        collectionsByResult.put(resultItem, realCollection);
                        categoryCollections.add(realCollection);
                    }
                    if (!realCollection.getRecipes().contains(recipe)) {
                        realCollection.getRecipes().add(recipe);
                    }
                    if ((opt = recipe.craftingRequirements()).isPresent()) {
                        for (Ingredient ingredient : (List)opt.get()) {
                            for (ItemStack stack : ingredient.display().resolveForStacks(context)) {
                                String ingredientId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase(Locale.ROOT);
                                ingredientIndex.computeIfAbsent(ingredientId, k -> new ArrayList()).add(realCollection);
                            }
                        }
                    }
                    String mod = BuiltInRegistries.ITEM.getKey((Object)resultItem).getNamespace().toLowerCase(Locale.ROOT);
                    for (int i = 0; i < mod.length(); ++i) {
                        for (int j = i + 1; j <= mod.length(); ++j) {
                            String substr = mod.substring(i, j);
                            if (substr.isEmpty()) continue;
                            modIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                        }
                    }
                    String resultId = BuiltInRegistries.ITEM.getKey((Object)resultItem).toString().toLowerCase(Locale.ROOT);
                    String name = result.getItemName().getString().toLowerCase(Locale.ROOT).replaceAll("[\\[\\]\u00ab\u00bb\"]", "");
                    for (String source : List.of(resultId, name)) {
                        for (int i = 0; i < source.length(); ++i) {
                            for (int j = i + 1; j <= source.length(); ++j) {
                                String substr = source.substring(i, j);
                                if (substr.isEmpty()) continue;
                                resultIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                            }
                        }
                    }
                    ArrayList<String> tooltipLines = new ArrayList<String>();
                    try {
                        TooltipFlag.Default tooltipFlag = TooltipFlag.Default.NORMAL;
                        List tooltip = result.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)tooltipFlag);
                        for (Component line : tooltip) {
                            String clean = ChatFormatting.stripFormatting((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                            tooltipLines.add(clean);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (String tooltipLine : tooltipLines) {
                        String[] words;
                        for (String word : words = tooltipLine.split("[\\s,;.:!\\-]+")) {
                            if (word.length() < 3) continue;
                            for (int i = 0; i <= word.length() - 3; ++i) {
                                for (int j = i + 3; j <= word.length(); ++j) {
                                    String substr = word.substring(i, j);
                                    if (substr.isEmpty()) continue;
                                    tooltipIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                                }
                            }
                        }
                    }
                }
            }
            RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.put(category, categoryCollections);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.put(category, resultIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.put(category, modIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.put(category, ingredientIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.put(category, tooltipIndex);
        }
        jebIndexReady = true;
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        JebClient.LOGGER.info("[JEB] buildRecipeIndex done at {} ({} ms), total indexed recipes: {}", new Object[]{new Date(endTime), duration, totalIndexedRecipes});
    }

    public static List<RecipeCollection> fastSearch(List<RecipeBookCategory> categories, String query, String modName, boolean searchIngredients) {
        if (!jebIndexReady) {
            return List.of();
        }
        query = query == null ? "" : query.toLowerCase(Locale.ROOT).trim();
        modName = modName == null ? "" : modName.toLowerCase(Locale.ROOT).trim();
        LinkedHashSet result = new LinkedHashSet();
        for (RecipeBookCategory category : categories) {
            Map modIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.getOrDefault(category, Map.of());
            Map ingredientIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.getOrDefault(category, Map.of());
            Set all = RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.getOrDefault(category, Set.of());
            Map resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.getOrDefault(category, Map.of());
            Map tooltipIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.getOrDefault(category, Map.of());
            if (modName.isEmpty() && query.isEmpty()) {
                result.addAll(all);
                continue;
            }
            if (!modName.isEmpty()) {
                List modCollections = modIndex.getOrDefault(modName, List.of());
                if (query.isEmpty()) {
                    result.addAll(modCollections);
                    continue;
                }
                for (String word : query.split("[\\s:_\\-]+")) {
                    List byWord = resultIndex.getOrDefault(word, List.of());
                    for (RecipeCollection rc : byWord) {
                        if (!modCollections.contains(rc)) continue;
                        result.add(rc);
                    }
                }
                continue;
            }
            if (searchIngredients && !query.isEmpty()) {
                List byIng = ingredientIndex.getOrDefault(query, List.of());
                result.addAll(byIng);
                continue;
            }
            if (query.isEmpty() || searchIngredients) continue;
            List byResult = resultIndex.getOrDefault(query, List.of());
            result.addAll(byResult);
            List byTooltip = tooltipIndex.getOrDefault(query, List.of());
            result.addAll(byTooltip);
        }
        return new ArrayList<RecipeCollection>(result);
    }

    public static List<RecipeCollection> fastSearch(Object categoryOrType, String query, String modName, boolean searchIngredients) {
        List<Object> categories = categoryOrType instanceof List ? (List<RecipeBookCategory>)categoryOrType : (categoryOrType instanceof SearchRecipeBookCategory ? ((SearchRecipeBookCategory)categoryOrType).includedCategories() : (categoryOrType instanceof RecipeBookCategory ? List.of((RecipeBookCategory)categoryOrType) : List.of()));
        return RecipeIndex.fastSearch(categories, query, modName, searchIngredients);
    }

    public static List<RecipeCollection> generateCustomRecipeList(String filter) {
        ArrayList<RecipeCollection> list = new ArrayList<RecipeCollection>();
        filter = filter.trim();
        String _modName = null;
        String _query = "";
        if (filter.startsWith("@")) {
            String[] parts = filter.substring(1).split(" ", 2);
            _modName = parts[0].toLowerCase(Locale.ROOT);
            if (parts.length > 1) {
                _query = parts[1].toLowerCase(Locale.ROOT);
            }
        } else {
            _query = filter.toLowerCase(Locale.ROOT);
        }
        String modName = _modName;
        String query = _query;
        ITEM_INDEX.stream().filter(idx -> !(modName != null && !idx.mod.contains(modName) || !query.isEmpty() && !idx.name.contains(query) && !idx.id.contains(query) && !idx.key.contains(query) && !idx.tooltip.stream().anyMatch(line -> line.contains(query)))).forEach(idx -> {
            RecipeCollection dummy = RecipeIndex.createDummyRecipeCollection(idx.item);
            list.add(dummy);
        });
        return list;
    }

    private static RecipeCollection createDummyRecipeCollection(Item item) {
        Identifier id = BuiltInRegistries.ITEM.getKey((Object)item);
        RecipeDisplayId recipeId = new RecipeDisplayId(9999);
        List<SlotDisplay.TagSlotDisplay> slots = List.of(new SlotDisplay.TagSlotDisplay(TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)id.getPath()))));
        SlotDisplay.ItemStackSlotDisplay resultSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)item, 1));
        Item ct = (Item)BuiltInRegistries.ITEM.getValue(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"crafting_table"));
        SlotDisplay.ItemStackSlotDisplay stationSlot = new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)ct));
        List<Ingredient> ingredients = List.of(Ingredient.of((ItemLike)item));
        ShapelessCraftingRecipeDisplay display = new ShapelessCraftingRecipeDisplay(slots, (SlotDisplay)resultSlot, (SlotDisplay)stationSlot);
        OptionalInt group = OptionalInt.empty();
        RecipeBookCategory category = RecipeBookCategories.CRAFTING_MISC;
        RecipeDisplayEntry entry = new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
        return new RecipeCollection(List.of(entry));
    }

    public static void fillItemIndex() {
        Minecraft client = Minecraft.getInstance();
        ITEM_INDEX.clear();
        for (Item item : JebClient.nonexistingResultItems) {
            if (item == Items.AIR) continue;
            String id = item.toString().toLowerCase(Locale.ROOT);
            String name = item.getName().getString().toLowerCase(Locale.ROOT);
            String mod = BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().toLowerCase(Locale.ROOT);
            String key = "";
            Component nameComponent = item.getName();
            ComponentContents componentContents = nameComponent.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                key = translatable.getKey().toLowerCase(Locale.ROOT);
            }
            ArrayList<String> tooltipLines = new ArrayList<String>();
            if (client.level != null) {
                try {
                    TooltipFlag.Default tooltipFlag = TooltipFlag.Default.NORMAL;
                    List tooltip = item.getDefaultInstance().getTooltipLines(Item.TooltipContext.of((Level)client.level), (Player)client.player, (TooltipFlag)tooltipFlag);
                    for (Component line : tooltip) {
                        String clean = ChatFormatting.stripFormatting((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                        tooltipLines.add(clean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ITEM_INDEX.add(new IndexedItem(item, id, name, mod, key, tooltipLines));
        }
    }

    public static boolean recipeIdExistsInIndex(RecipeBookCategory category, RecipeDisplayEntry recipeEntry) {
        Map<String, List<RecipeCollection>> resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.get(category);
        if (resultIndex == null) {
            return false;
        }
        ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        ItemStack result = recipeEntry.display().result().resolveForFirstStack(context);
        if (result == null || result.isEmpty()) {
            return false;
        }
        String resultId = BuiltInRegistries.ITEM.getKey((Object)result.getItem()).toString().toLowerCase(Locale.ROOT);
        List<RecipeCollection> collections = resultIndex.get(resultId);
        if (collections == null) {
            return false;
        }
        String incomingId = recipeEntry.id().toString();
        for (RecipeCollection collection : collections) {
            for (RecipeDisplayEntry r : collection.getRecipes()) {
                if (!r.id().toString().equals(incomingId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateIndexesWithRecipe(RecipeBookCategory category, RecipeCollection collection, RecipeDisplayEntry recipeEntry) {
        RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet()).add(collection);
        ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        ItemStack result = recipeEntry.display().result().resolveForFirstStack(context);
        if (result == null || result.isEmpty()) {
            return;
        }
        Item resultItem = result.getItem();
        String mod = BuiltInRegistries.ITEM.getKey((Object)resultItem).getNamespace().toLowerCase(Locale.ROOT);
        Map modIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.computeIfAbsent(category, k -> new HashMap());
        for (int i = 0; i < mod.length(); ++i) {
            for (int j = i + 1; j <= mod.length(); ++j) {
                Object list;
                String substr = mod.substring(i, j);
                if (substr.isEmpty() || (list = modIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                list.add(collection);
            }
        }
        String resultId = BuiltInRegistries.ITEM.getKey((Object)resultItem).toString().toLowerCase(Locale.ROOT);
        String name = result.getItemName().getString().toLowerCase(Locale.ROOT).replaceAll("[\\[\\]\u00ab\u00bb\"]", "");
        Map resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.computeIfAbsent(category, k -> new HashMap());
        for (String source : List.of(resultId, name)) {
            for (int i = 0; i < source.length(); ++i) {
                for (int j = i + 1; j <= source.length(); ++j) {
                    List list;
                    String substr = source.substring(i, j);
                    if (substr.isEmpty() || (list = resultIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                    list.add(collection);
                }
            }
        }
        Map ingredientIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.computeIfAbsent(category, k -> new HashMap());
        Optional opt = recipeEntry.craftingRequirements();
        if (opt.isPresent()) {
            for (Ingredient ingredient : (List)opt.get()) {
                for (ItemStack stack : ingredient.display().resolveForStacks(context)) {
                    String ingredientId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase(Locale.ROOT);
                    List list = ingredientIndex.computeIfAbsent(ingredientId, k -> new ArrayList());
                    if (list.contains(collection)) continue;
                    list.add(collection);
                }
            }
        }
        Map tooltipIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.computeIfAbsent(category, k -> new HashMap());
        ArrayList<String> tooltipLines = new ArrayList<String>();
        try {
            TooltipFlag.Default tooltipFlag = TooltipFlag.Default.NORMAL;
            List tooltip = result.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)tooltipFlag);
            for (Component line : tooltip) {
                String clean = ChatFormatting.stripFormatting((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                tooltipLines.add(clean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String tooltipLine : tooltipLines) {
            String[] words;
            for (String word : words = tooltipLine.split("[\\s,;.:!\\-]+")) {
                if (word.length() < 3) continue;
                for (int i = 0; i <= word.length() - 3; ++i) {
                    for (int j = i + 3; j <= word.length(); ++j) {
                        List list;
                        String substr = word.substring(i, j);
                        if (substr.isEmpty() || (list = tooltipIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                        list.add(collection);
                    }
                }
            }
        }
    }

    public static void addRecipeToCollectionIfAbsent(RecipeBookCategory category, RecipeDisplayEntry recipeEntry, ContextMap context) {
        List recipes;
        Map byItem = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
        ItemStack result = recipeEntry.display().result().resolveForFirstStack(context);
        if (result == null || result.isEmpty()) {
            return;
        }
        Item resultItem = result.getItem();
        RecipeCollection collection = (RecipeCollection)byItem.get(resultItem);
        if (collection == null) {
            collection = new RecipeCollection(new ArrayList());
            byItem.put(resultItem, collection);
            RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet()).add(collection);
        }
        if ((recipes = collection.getRecipes()).contains(recipeEntry)) {
            return;
        }
        try {
            recipes.add(recipeEntry);
        }
        catch (UnsupportedOperationException e) {
            ArrayList<RecipeDisplayEntry> fixed = new ArrayList<RecipeDisplayEntry>(recipes);
            fixed.add(recipeEntry);
            RecipeCollection newCollection = new RecipeCollection(fixed);
            byItem.put(resultItem, newCollection);
            Set set = RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet());
            set.remove(collection);
            set.add(newCollection);
        }
    }

    public static void addAndIndexRecipeIfAbsent(RecipeBookCategory category, RecipeDisplayEntry recipeEntry, ContextMap context) {
        RecipeIndex.addRecipeToCollectionIfAbsent(category, recipeEntry, context);
        Map byItem = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
        ItemStack result = recipeEntry.display().result().resolveForFirstStack(context);
        if (result == null || result.isEmpty()) {
            return;
        }
        Item resultItem = result.getItem();
        RecipeCollection collection = (RecipeCollection)byItem.get(resultItem);
        if (collection == null) {
            return;
        }
        RecipeIndex.updateIndexesWithRecipe(category, collection, recipeEntry);
    }

    public static class IndexedItem {
        public final Item item;
        public final String id;
        public final String name;
        public final String mod;
        public final String key;
        public final List<String> tooltip;

        public IndexedItem(Item item, String id, String name, String mod, String key, List<String> tooltip) {
            this.item = item;
            this.id = id;
            this.name = name;
            this.mod = mod;
            this.key = key;
            this.tooltip = tooltip;
        }
    }
}

