/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import client.JebClient;
import client.RecipeIndex;
import client.RecipeLoader;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPlayNetworkHandlerMixin {
    @Unique
    private static final Map<String, Integer> VANILLA_RECIPE_COUNTS = Map.of("1.21.4", 1358, "1.21.5", 1361, "1.21.6", 1395, "1.21.7", 1395, "1.21.8", 1395, "1.21.9", 1449, "1.21.10", 1449, "1.21.11", 1459);
    @Unique
    private static final Map<String, Integer> VANILLA_CT_ID = Map.of("1.21.4", 259, "1.21.5", 259, "1.21.6", 262, "1.21.7", 262, "1.21.8", 262, "1.21.9", 283, "1.21.10", 283, "1.21.11", 284);

    @Inject(method={"handleRecipeBookAdd"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/ClientRecipeBook;add(Lnet/minecraft/world/item/crafting/display/RecipeDisplayEntry;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectOnRecipeBookAdd(ClientboundRecipeBookAddPacket p_379950_, CallbackInfo ci, ClientRecipeBook clientrecipebook, Iterator var3, ClientboundRecipeBookAddPacket.Entry clientboundrecipebookaddpacket$entry) {
        ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level)));
        if (JebClient.recipesLoaded) {
            long startTime = System.currentTimeMillis();
            RecipeBookCategory category = clientboundrecipebookaddpacket$entry.contents().category();
            RecipeDisplayEntry entry = clientboundrecipebookaddpacket$entry.contents();
            JebClient.LOGGER.info("[JEB] checking recipe {} started at {}", (Object)entry.display().result().resolveForFirstStack(context).getItem().toString(), (Object)new Date(startTime));
            if (!RecipeIndex.recipeIdExistsInIndex(category, entry)) {
                RecipeIndex.addAndIndexRecipeIfAbsent(category, entry, context);
                JebClient.LOGGER.info("[JEB] The recipe has been added: {}", (Object)entry.display().result().resolveForFirstStack(context).toString());
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            JebClient.LOGGER.info("[JEB] checking recipe done at {} ({} ms)", (Object)new Date(endTime), (Object)duration);
            return;
        }
        SlotDisplay resultSlot = clientboundrecipebookaddpacket$entry.contents().display().result();
        List stacks = resultSlot.resolveForStacks(context);
        if (stacks.isEmpty()) {
            System.err.println("Warning: Empty stacks for resultSlot in recipe " + String.valueOf(clientboundrecipebookaddpacket$entry));
            return;
        }
        ItemStack stack = (ItemStack)stacks.get(0);
        if (((ItemStack)clientboundrecipebookaddpacket$entry.contents().display().craftingStation().resolveForStacks(context).getFirst()).getItem() == Items.CRAFTING_TABLE) {
            JebClient.existingResultItems.add(stack.getItem());
        }
    }

    @Inject(method={"handleRecipeBookAdd"}, at={@At(value="TAIL")})
    private void afterRecipeBookAdd(ClientboundRecipeBookAddPacket p_379950_, CallbackInfo ci) {
        if (JebClient.recipesLoaded) {
            return;
        }
        String version = SharedConstants.getCurrentVersion().name();
        int vanillaMaxRecipes = VANILLA_RECIPE_COUNTS.getOrDefault(version, 1358);
        int vanillaCTID = VANILLA_CT_ID.getOrDefault(version, 259);
        Minecraft client = Minecraft.getInstance();
        int knownRecipeCount = 0;
        int craftingStationId = 0;
        ClientRecipeBook recipeBook = client.player.getRecipeBook();
        List recipes = recipeBook.getCollections();
        for (RecipeCollection collection : recipes) {
            List entries = collection.getRecipes();
            for (RecipeDisplayEntry entry : entries) {
                ContextMap context;
                SlotDisplay resultSlot = entry.display().result();
                List stacks = resultSlot.resolveForStacks(context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(Minecraft.getInstance().level))));
                ItemStack stack = (ItemStack)stacks.getFirst();
                if (stack.getItem() == Items.CRAFTING_TABLE) {
                    craftingStationId = entry.id().index();
                }
                ++knownRecipeCount;
            }
        }
        if (knownRecipeCount < vanillaMaxRecipes && craftingStationId == vanillaCTID) {
            try {
                RecipeLoader.loadRecipesFromLog();
                JebClient.recipesLoaded = true;
                RecipeIndex.buildRecipeIndex();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (knownRecipeCount >= vanillaMaxRecipes || craftingStationId != vanillaCTID && craftingStationId != 0) {
            JebClient.recipesLoaded = true;
            RecipeIndex.buildRecipeIndex();
        }
        if (JebClient.recipesLoaded) {
            JebClient.nonexistingResultItems.clear();
            for (Item item : BuiltInRegistries.ITEM) {
                if (item == Items.AIR || JebClient.existingResultItems.contains(item)) continue;
                JebClient.nonexistingResultItems.add(item);
            }
            RecipeIndex.fillItemIndex();
        }
    }
}

