/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import jeb.accessor.ClientRecipeBookAccessor;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientRecipeBook.class})
public abstract class ClientRecipeBookMixin
implements ClientRecipeBookAccessor {
    @Override
    @Accessor(value="known")
    public abstract Map<RecipeDisplayId, RecipeDisplayEntry> getRecipes();

    @Inject(method={"categorizeAndGroupRecipes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectToGroupedMap(Iterable<RecipeDisplayEntry> recipes, CallbackInfoReturnable<Map<RecipeBookCategory, List<List<RecipeDisplayEntry>>>> cir) {
        HashMap<RecipeBookCategory, List> map = new HashMap<RecipeBookCategory, List>();
        for (RecipeDisplayEntry recipeDisplayEntry : recipes) {
            RecipeBookCategory recipeBookCategory = recipeDisplayEntry.category();
            OptionalInt optionalInt = OptionalInt.empty();
            map.computeIfAbsent(recipeBookCategory, group -> new ArrayList()).add(List.of(recipeDisplayEntry));
        }
        cir.setReturnValue(map);
    }
}

