/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import client.FavoritesManager;
import client.JebClient;
import client.RecipeIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import jeb.accessor.AnimatedResultButtonExtension;
import jeb.accessor.ClientRecipeBookAccessor;
import jeb.accessor.RecipeBookWidgetBridge;
import jeb.mixin.RecipeBookResultsAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookWidgetSearchMixin<T extends RecipeBookMenu>
implements RecipeBookWidgetBridge {
    @Final
    @Shadow
    protected RecipeBookMenu menu;
    @Shadow
    @Final
    private StackedItemContents stackedContents;
    @Shadow
    private ClientRecipeBook book;
    @Shadow
    private RecipeBookTabButton selectedTab;
    @Shadow
    protected Minecraft minecraft;
    @Final
    @Shadow
    private RecipeBookPage recipeBookPage;
    @Shadow
    private EditBox searchBox;
    @Shadow
    @Final
    private List<RecipeBookComponent.TabInfo> tabInfos;
    @Shadow
    @Final
    private List<RecipeBookTabButton> tabButtons;
    @Shadow
    protected CycleButton<Boolean> filterButton;
    @Unique
    private CycleButton<Boolean> jeb$customToggleButton;
    @Unique
    private boolean jeb$customToggleState = false;
    @Unique
    private static final WidgetSprites TEXTURES_ALT = new WidgetSprites(Identifier.withDefaultNamespace((String)"recipe_book/crafting_overlay"), Identifier.withDefaultNamespace((String)"recipe_book/crafting_overlay_highlighted"));
    @Unique
    private static final WidgetSprites TEXTURES_DEFAULT = new WidgetSprites(Identifier.withDefaultNamespace((String)"recipe_book/crafting_overlay_disabled"), Identifier.withDefaultNamespace((String)"recipe_book/crafting_overlay_disabled_highlighted"));

    @Shadow
    private void initVisuals() {
    }

    @Override
    public void jeb$refresh() {
        this.initVisuals();
    }

    @Inject(method={"selectMatchingRecipes()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void populateAllRecipes(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"initVisuals"}, at={@At(value="TAIL")})
    private void jeb$addCustomToggleButton(CallbackInfo ci) {
        int x = this.filterButton.getX();
        int y = this.filterButton.getY() + 125;
        this.jeb$customToggleState = JebClient.customToggleEnabled;
        this.jeb$customToggleButton = CycleButton.onOffBuilder((boolean)JebClient.customToggleEnabled).withTooltip(value -> Tooltip.create((Component)Component.literal((String)(value != false ? "Show 3x3" : "Show 2x2")))).withSprite((button, value) -> {
            WidgetSprites sprites = value != false ? TEXTURES_ALT : TEXTURES_DEFAULT;
            return sprites.get(true, button.isHoveredOrFocused());
        }).displayState(CycleButton.DisplayState.HIDE).create(x, y, 20, 16, (Component)Component.literal((String)"!"), (cycle, value) -> {
            this.jeb$customToggleState = value;
            JebClient.customToggleEnabled = value;
            JebClient.saveConfig();
            this.jeb$refresh();
        });
        this.jeb$customToggleButton.visible = true;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CycleButton;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", ordinal=0, shift=At.Shift.AFTER)})
    private void jeb$renderCustomToggle(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.jeb$customToggleButton != null && this.jeb$customToggleButton.visible) {
            this.jeb$customToggleButton.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void jeb$clickCustomToggle(MouseButtonEvent event, boolean doubleClick, CallbackInfoReturnable<Boolean> cir) {
        if (this.jeb$customToggleButton != null && this.jeb$customToggleButton.mouseClicked(event, doubleClick)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean isFavoritesTabActive() {
        return this.selectedTab.getCategory() == RecipeBookCategories.CAMPFIRE;
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        RecipeButton hovered;
        if (JebClient.keyBinding2 != null && event.key() == JebClient.keyBinding2.getKey().getValue() && (hovered = ((RecipeBookResultsAccessor)this.recipeBookPage).getHoveredResultButton()) != null) {
            if (this.isFavoritesTabActive()) {
                FavoritesManager.removeFavorite(hovered.getDisplayStack());
                this.jeb$refresh();
            } else {
                FavoritesManager.saveFavorite(hovered.getDisplayStack());
            }
            ((AnimatedResultButtonExtension)hovered).jeb$flash();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tryPlaceRecipe"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handlePlaceRecipe(ILnet/minecraft/world/item/crafting/display/RecipeDisplayId;Z)V", shift=At.Shift.AFTER)})
    private void onRecipeClicked(RecipeCollection recipeCollection, RecipeDisplayId recipe, boolean useMaxItems, CallbackInfoReturnable<Boolean> cir) {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        ClientRecipeBook recipeBook = client.player.getRecipeBook();
        Map<RecipeDisplayId, RecipeDisplayEntry> recipes = ((ClientRecipeBookAccessor)recipeBook).getRecipes();
        RecipeDisplayEntry entry = recipes.get(recipe);
        Screen screen = client.screen;
        if (screen instanceof RecipeUpdateListener) {
            RecipeUpdateListener provider = (RecipeUpdateListener)screen;
            if (entry != null && !recipeCollection.isCraftable(recipe) && recipe.index() != 9999) {
                provider.fillGhostRecipe(entry.display());
            }
        }
    }

    @Unique
    private boolean recipeDisplayMatchesIngredientQuery(RecipeDisplayEntry entry, String query) {
        if (entry.craftingRequirements().isEmpty()) {
            return false;
        }
        return ((List)entry.craftingRequirements().get()).stream().anyMatch(ingredient -> ingredient.items().anyMatch(regEntry -> {
            ItemStack stack = new ItemStack((ItemLike)regEntry.value());
            String itemName = stack.getItem().getName().getString().toLowerCase(Locale.ROOT);
            return itemName.contains(query);
        }));
    }

    @Unique
    private boolean recipeResultMatchesQuery(RecipeDisplayEntry entry, String query, String modName) {
        ContextMap context;
        SlotDisplay resultSlot = entry.display().result();
        List stacks = resultSlot.resolveForStacks(context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(this.minecraft.level))));
        if (stacks.isEmpty()) {
            return false;
        }
        ItemStack stack = (ItemStack)stacks.get(0);
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        String name = stack.getDisplayName().getString().toLowerCase(Locale.ROOT);
        String id = stack.getItem().toString().toLowerCase(Locale.ROOT);
        String key = "";
        Component nameComponent = stack.getHoverName();
        ComponentContents componentContents = nameComponent.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            key = translatable.getKey().toLowerCase(Locale.ROOT);
        }
        if (modName != null && !modName.isEmpty() && !BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().contains(modName)) {
            return false;
        }
        if (name.contains(query) || id.contains(query) || key.contains(query)) {
            return true;
        }
        TooltipFlag.Default tooltipFlag = this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        try {
            List tooltip = stack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.level), (Player)this.minecraft.player, (TooltipFlag)tooltipFlag);
            for (Component line : tooltip) {
                String clean = ChatFormatting.stripFormatting((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                if (!clean.contains(query)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static RecipeDisplayEntry createDummySingleItemRecipe(ItemStack stack) {
        Identifier id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        RecipeDisplayId recipeId = new RecipeDisplayId(9999);
        List<SlotDisplay.TagSlotDisplay> slots = List.of(new SlotDisplay.TagSlotDisplay(TagKey.create((ResourceKey)Registries.ITEM, (Identifier)id)));
        SlotDisplay.ItemStackSlotDisplay resultSlot = new SlotDisplay.ItemStackSlotDisplay(stack.copy());
        SlotDisplay.ItemSlotDisplay stationSlot = new SlotDisplay.ItemSlotDisplay((Item)BuiltInRegistries.ITEM.getValue(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"crafting_table")));
        ShapelessCraftingRecipeDisplay display = new ShapelessCraftingRecipeDisplay(slots, (SlotDisplay)resultSlot, (SlotDisplay)stationSlot);
        OptionalInt group = OptionalInt.empty();
        RecipeBookCategory category = RecipeBookCategories.CRAFTING_MISC;
        List<Ingredient> ingredients = List.of(Ingredient.of((ItemLike)stack.getItem()));
        return new RecipeDisplayEntry(recipeId, (RecipeDisplay)display, group, category, Optional.of(ingredients));
    }

    @Inject(method={"updateCollections"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCustomSearch(boolean resetCurrentPage, boolean filteringCraftable, CallbackInfo ci) {
        String rawInput = this.searchBox.getValue();
        if (rawInput == null) {
            rawInput = "";
        }
        boolean searchIngredients = rawInput.startsWith("#");
        boolean searchByResult = rawInput.startsWith("~");
        String query = (searchIngredients || searchByResult ? rawInput.substring(1) : rawInput).toLowerCase(Locale.ROOT);
        String modName = null;
        if (rawInput.startsWith("@")) {
            int endIndex = rawInput.indexOf(" ");
            if (endIndex != -1) {
                modName = rawInput.substring(1, endIndex).trim();
                query = rawInput.substring(endIndex + 1).toLowerCase(Locale.ROOT);
            } else {
                modName = rawInput.substring(1).trim();
                query = "";
            }
        }
        List collections = this.book.getCollection(this.selectedTab.getCategory());
        ArrayList<Object> filteredList = new ArrayList();
        if (rawInput.startsWith("~") && !this.isFavoritesTabActive()) {
            ContextMap context = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(this.minecraft.level)));
            ArrayList<RecipeCollection> arrayList = new ArrayList<RecipeCollection>();
            for (RecipeCollection collection : this.book.getCollection(this.selectedTab.getCategory())) {
                for (RecipeDisplayEntry recipe1 : collection.getRecipes()) {
                    ItemStack result;
                    String resultName;
                    SlotDisplay resultSlot = recipe1.display().result();
                    List stacks = resultSlot.resolveForStacks(context);
                    if (stacks.isEmpty() || !(resultName = BuiltInRegistries.ITEM.getKey((Object)(result = (ItemStack)stacks.get(0)).getItem()).getPath().toLowerCase(Locale.ROOT)).equals(query)) continue;
                    block2: for (Ingredient ingredient : (List)recipe1.craftingRequirements().get()) {
                        for (ItemStack stack2 : ingredient.display().resolveForStacks(context)) {
                            if (stack2.isEmpty()) continue;
                            boolean foundReal = false;
                            for (RecipeCollection subCollection : this.book.getCollection((ExtendedRecipeBookCategory)SearchRecipeBookCategory.CRAFTING)) {
                                for (RecipeDisplayEntry subRecipe : subCollection.getRecipes()) {
                                    ItemStack subResult;
                                    SlotDisplay subResultSlot = subRecipe.display().result();
                                    List subStacks = subResultSlot.resolveForStacks(context);
                                    if (subStacks.isEmpty() || (subResult = (ItemStack)subStacks.get(0)).isEmpty() || !ItemStack.isSameItem((ItemStack)subResult, (ItemStack)stack2)) continue;
                                    subCollection.selectRecipes(this.stackedContents, r -> true);
                                    arrayList.add(subCollection);
                                    foundReal = true;
                                    break;
                                }
                                if (!foundReal) continue;
                                break;
                            }
                            if (foundReal) continue block2;
                            RecipeDisplayEntry fakeRecipe = RecipeBookWidgetSearchMixin.createDummySingleItemRecipe(stack2);
                            RecipeCollection fakeCollection = new RecipeCollection(List.of(fakeRecipe));
                            fakeCollection.selectRecipes(this.stackedContents, r -> true);
                            arrayList.add(fakeCollection);
                            continue block2;
                        }
                    }
                }
            }
            filteredList.addAll(arrayList);
            this.recipeBookPage.updateCollections(filteredList, resetCurrentPage, filteringCraftable);
            ci.cancel();
            return;
        }
        if (this.isFavoritesTabActive()) {
            collections = this.book.getCollection((ExtendedRecipeBookCategory)SearchRecipeBookCategory.CRAFTING);
            Set<Identifier> favoriteItems = FavoritesManager.loadFavoriteItemIds();
            ContextMap contextMap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(this.minecraft.level)));
            for (RecipeCollection collection : collections) {
                boolean hasFavorite = collection.getRecipes().stream().flatMap(entry -> entry.resultItems(context).stream()).map(stack -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).anyMatch(favoriteItems::contains);
                if (!hasFavorite) continue;
                collection.selectRecipes(this.stackedContents, r -> true);
                filteredList.add(collection);
            }
            this.recipeBookPage.updateCollections(filteredList, resetCurrentPage, filteringCraftable);
            ci.cancel();
            return;
        }
        filteredList = new ArrayList<RecipeCollection>(RecipeIndex.fastSearch(this.selectedTab.getCategory(), query, modName, searchIngredients));
        for (RecipeCollection recipeCollection : filteredList) {
            if (JebClient.customToggleEnabled) {
                recipeCollection.selectRecipes(this.stackedContents, r -> true);
                continue;
            }
            recipeCollection.selectRecipes(this.stackedContents, this::jEB$canDisplay);
        }
        if (filteringCraftable) {
            filteredList.removeIf(rc -> !rc.hasCraftable());
        }
        if (!Objects.equals(JebClient.string, rawInput)) {
            JebClient.filtered = RecipeIndex.generateCustomRecipeList(rawInput);
        }
        if (!((Boolean)this.filterButton.getValue()).booleanValue()) {
            filteredList.addAll(JebClient.filtered);
        }
        JebClient.string = rawInput;
        this.recipeBookPage.updateCollections(filteredList, resetCurrentPage, filteringCraftable);
        ci.cancel();
    }

    @Unique
    private boolean jEB$canDisplay(RecipeDisplay display) {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (!(recipeBookMenu instanceof AbstractCraftingMenu)) {
            return true;
        }
        AbstractCraftingMenu craftingHandler = (AbstractCraftingMenu)recipeBookMenu;
        int w = craftingHandler.getGridWidth();
        int h = craftingHandler.getGridHeight();
        if (display instanceof ShapedCraftingRecipeDisplay) {
            ShapedCraftingRecipeDisplay shaped = (ShapedCraftingRecipeDisplay)display;
            return w >= shaped.width() && h >= shaped.height();
        }
        if (display instanceof ShapelessCraftingRecipeDisplay) {
            ShapelessCraftingRecipeDisplay shapeless = (ShapelessCraftingRecipeDisplay)display;
            return w * h >= shapeless.ingredients().size();
        }
        return false;
    }
}

