/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounter
extends GuiParent {
    public int min;
    public int max;
    public final GuiParent buttons;
    public GuiTextfield textfield;
    public final ControlFormatting buttonsFormatting;

    public GuiCounter(IGuiParent parent, String name, int value) {
        this(parent, name, value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public GuiCounter(IGuiParent parent, String name, int value, int min, int max) {
        this(parent, name, value, min, max, ControlFormatting.TRANSPARENT);
    }

    public GuiCounter(IGuiParent parent, String name, int value, int min, int max, ControlFormatting buttonsFormatting) {
        super(parent, name);
        this.min = min;
        this.max = max;
        this.dist().setFlow(GuiFlow.STACK_X);
        this.setSpacing(1);
        this.textfield = new GuiTextfield(this, "value", "" + Mth.clamp((int)value, (int)min, (int)max)).setDim(20, 10).setNumbersIncludingNegativeOnly();
        this.buttons = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y);
        this.buttons.setSpacing(0);
        this.buttonsFormatting = buttonsFormatting;
        this.createButtons();
        this.add(this.textfield.setExpandableX());
        this.add((GuiControl)this.buttons);
    }

    protected void createButtons() {
        this.buttons.add(new GuiButtonHold(this, "+", x -> {
            this.textfield.setText("" + this.stepUp(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
        }).setHoverEffect(true).setTranslate("gui.plus").setDim(6, 3).setFormatting(this.buttonsFormatting));
        this.buttons.add(new GuiButtonHold(this, "-", x -> {
            this.textfield.setText("" + this.stepDown(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
        }).setHoverEffect(true).setTranslate("gui.minus").setDim(6, 4).setFormatting(this.buttonsFormatting));
    }

    @Override
    public GuiCounter setSpacing(int spacing) {
        return (GuiCounter)super.setSpacing(spacing);
    }

    @Override
    public GuiCounter add(GuiControl control) {
        return (GuiCounter)super.add(control);
    }

    @Override
    public boolean isExpandableX() {
        if (this.dist() != null) {
            return this.dist().isExpandableX();
        }
        return false;
    }

    public GuiButtonHold getPlusButton() {
        return (GuiButtonHold)this.buttons.get("+");
    }

    public GuiButtonHold getMinusButton() {
        return (GuiButtonHold)this.buttons.get("-");
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    public int stepUp(int value) {
        return Math.min(this.max, value + 1);
    }

    public int stepDown(int value) {
        return Math.max(this.min, value - 1);
    }

    public int getValue() {
        return Mth.clamp((int)this.textfield.parseInteger(), (int)this.min, (int)this.max);
    }

    public void setValue(int value) {
        this.textfield.setText("" + Mth.clamp((int)value, (int)this.min, (int)this.max));
    }
}

