/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.handler;

import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WaystoneDebugHandler {
    public static void register() {
        BlockCallback.Use.EVENT.register((player, level, hand, hitResult) -> {
            ItemStack heldItem = player.getItemInHand(hand);
            if (player.getAbilities().instabuild) {
                BlockEntity blockEntity = level.getBlockEntity(hitResult.getBlockPos());
                if (!(blockEntity instanceof WaystoneBlockEntityBase)) {
                    return InteractionEventResult.DEFAULT;
                }
                WaystoneBlockEntityBase waystoneBase = (WaystoneBlockEntityBase)blockEntity;
                if (heldItem.getItem() == Items.BAMBOO) {
                    if (!level.isClientSide()) {
                        waystoneBase.uninitializeWaystone();
                        player.displayClientMessage((Component)Component.literal((String)"Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                    }
                    return InteractionEventResult.SUCCESS;
                }
                if (heldItem.getItem() == Items.STICK) {
                    if (!level.isClientSide()) {
                        player.displayClientMessage((Component)Component.literal((String)("Server UUID: " + String.valueOf(waystoneBase.getWaystone().getWaystoneUid()))), false);
                    }
                    if (level.isClientSide()) {
                        player.displayClientMessage((Component)Component.literal((String)("Client UUID: " + String.valueOf(waystoneBase.getWaystone().getWaystoneUid()))), false);
                    }
                    return InteractionEventResult.SUCCESS;
                }
            }
            return InteractionEventResult.DEFAULT;
        });
    }
}

