/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.handler;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WaystoneEditInteractionHandler {
    public static void register() {
        BlockCallback.Use.EVENT.register((player, level, hand, hitResult) -> {
            if (!player.isShiftKeyDown()) {
                return InteractionEventResult.DEFAULT;
            }
            ItemStack itemStack = player.getItemInHand(hand);
            if (itemStack.getItem() instanceof BlockItem) {
                return InteractionEventResult.DEFAULT;
            }
            BlockPos pos = hitResult.getBlockPos();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof WaystoneBlockEntityBase)) {
                return InteractionEventResult.DEFAULT;
            }
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            if (!level.isClientSide()) {
                waystoneBlockEntity.getSettingsMenuProvider().ifPresent(menuProvider -> Balm.networking().openMenu(player, menuProvider));
            }
            return InteractionEventResult.SUCCESS;
        });
    }
}

