/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.component.WaystoneReferenceComponent;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ShardItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttunedShardItem
extends ShardItem
implements IAttunementItem {
    public AbstractAttunedShardItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        UUID legacyAttunement;
        WaystoneReferenceComponent attunement = (WaystoneReferenceComponent)stack.get((DataComponentType)ModComponents.warpPlateAttunement.value());
        if (attunement != null) {
            list.accept(WarpPlateBlock.getGalacticName(attunement.waystoneId()));
        }
        if ((legacyAttunement = (UUID)stack.get((DataComponentType)ModComponents.attunement.value())) != null) {
            list.accept(WarpPlateBlock.getGalacticName(legacyAttunement));
        }
        list.accept((Component)Component.translatable((String)"tooltip.waystones.attuned_shard.plug_into_warp_plate"));
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, Player player, ItemStack itemStack) {
        WaystoneReferenceComponent attunement = (WaystoneReferenceComponent)itemStack.get((DataComponentType)ModComponents.warpPlateAttunement.value());
        if (attunement != null) {
            return Optional.of(new WaystoneProxy(server, attunement.waystoneId()));
        }
        UUID legacyAttunement = (UUID)itemStack.get((DataComponentType)ModComponents.attunement.value());
        if (legacyAttunement != null) {
            return Optional.of(new WaystoneProxy(server, legacyAttunement));
        }
        return Optional.empty();
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable Waystone waystone) {
        if (waystone != null) {
            itemStack.set((DataComponentType)ModComponents.warpPlateAttunement.value(), (Object)new WaystoneReferenceComponent(waystone.getWaystoneUid(), waystone.getName()));
        } else {
            itemStack.remove((DataComponentType)ModComponents.warpPlateAttunement.value());
        }
    }
}

