/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.worldgen.namegen.BiomeNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.CustomNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MixedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MrPorkNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.RomanNumber;
import net.blay09.mods.waystones.worldgen.namegen.SequencedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.TemplateNameGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class NameGeneratorManager
extends SavedData {
    private static final String DATA_NAME = "waystones_name_generator";
    private static final Codec<NameGeneratorManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("UsedNames").forGetter(NameGeneratorManager::getUsedNames)).apply((Applicative)instance, NameGeneratorManager::new));
    public static final SavedDataType<NameGeneratorManager> TYPE = new SavedDataType("waystones_name_generator", () -> new NameGeneratorManager(List.of()), CODEC, null);
    private final Set<String> usedNames = Sets.newHashSet();

    public NameGeneratorManager(List<String> usedNames) {
        this.usedNames.addAll(usedNames);
    }

    public static NameGeneratorManager get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        return (NameGeneratorManager)Objects.requireNonNull(overworld).getDataStorage().computeIfAbsent(TYPE);
    }

    public List<String> getUsedNames() {
        return new ArrayList<String>(this.usedNames);
    }

    private NameGenerator getNameGenerator(NameGenerationMode nameGenerationMode) {
        TemplateNameGenerator randomGenerator = new TemplateNameGenerator(WaystonesConfig.getActive().worldGen.nameGenerationTemplate).with("MrPork", new MrPorkNameGenerator()).with("Biome", new BiomeNameGenerator());
        switch (nameGenerationMode) {
            case MIXED: {
                return new MixedNameGenerator(randomGenerator, new CustomNameGenerator(false, this.usedNames));
            }
            case RANDOM_ONLY: {
                return randomGenerator;
            }
            case PRESET_ONLY: {
                return new CustomNameGenerator(true, this.usedNames);
            }
        }
        return new SequencedNameGenerator(new CustomNameGenerator(false, this.usedNames), randomGenerator);
    }

    public synchronized Component getName(LevelAccessor level, Waystone waystone, RandomSource rand, NameGenerationMode nameGenerationMode) {
        NameGenerator nameGenerator = this.getNameGenerator(nameGenerationMode);
        Component originalName = nameGenerator.generateName(level, waystone, rand).orElse((Component)Component.empty());
        Component name = this.resolveDuplicate(originalName);
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(waystone, name);
        ((Consumer)GenerateWaystoneNameEvent.EVENT.invoker()).accept(new GenerateWaystoneNameEvent(waystone, name));
        name = event.getName();
        this.usedNames.add(name.getString());
        this.setDirty();
        return name;
    }

    private Component resolveDuplicate(Component name) {
        Component tryName = name;
        int i = 1;
        while (this.usedNames.contains(tryName.getString())) {
            tryName = name.copy().append(" " + RomanNumber.toRoman(i));
            ++i;
        }
        return tryName;
    }
}

