/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntityRenderDispatcher.class})
public abstract class BlockEntityRenderDispatcherMixin {
    @Inject(method={"tryExtractRenderState(Lnet/minecraft/world/level/block/entity/BlockEntity;FLnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)Lnet/minecraft/client/renderer/blockentity/state/BlockEntityRenderState;"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryExtractRenderState(BlockEntity blockEntity, float f, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, CallbackInfoReturnable<BlockEntityRenderState> info) {
        if (EntityCullingModBase.instance.config.skipBlockEntityCulling) {
            return;
        }
        BlockEntityRenderer blockEntityRenderer = this.getRenderer(blockEntity);
        if (blockEntityRenderer == null) {
            return;
        }
        Frustum frustum = EntityCullingModBase.instance.frustum;
        if (blockEntityRenderer.shouldRenderOffScreen()) {
            ++EntityCullingModBase.instance.renderedBlockEntities;
            return;
        }
        if (EntityCullingModBase.instance.config.blockEntityFrustumCulling && frustum != null && !frustum.isVisible(EntityCullingModBase.instance.setupAABB(blockEntity, blockEntity.getBlockPos()))) {
            ++EntityCullingModBase.instance.skippedBlockEntities;
            info.setReturnValue(null);
            return;
        }
        if (blockEntity instanceof Cullable) {
            Cullable cullable = (Cullable)blockEntity;
            if (!cullable.isForcedVisible() && cullable.isCulled()) {
                ++EntityCullingModBase.instance.skippedBlockEntities;
                info.setReturnValue(null);
                return;
            }
            ++EntityCullingModBase.instance.renderedBlockEntities;
            cullable.setOutOfCamera(false);
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;tryExtractRenderState(Lnet/minecraft/world/level/block/entity/BlockEntity;FLnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;Lnet/minecraft/client/renderer/culling/Frustum;)Lnet/minecraft/client/renderer/blockentity/state/BlockEntityRenderState;"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryExtractRenderState(BlockEntity blockEntity, float f, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, Frustum frustum, CallbackInfoReturnable<BlockEntityRenderState> info) {
        if (EntityCullingModBase.instance.config.skipBlockEntityCulling) {
            return;
        }
        BlockEntityRenderer blockEntityRenderer = this.getRenderer(blockEntity);
        if (blockEntityRenderer == null) {
            return;
        }
        if (blockEntityRenderer.shouldRenderOffScreen()) {
            ++EntityCullingModBase.instance.renderedBlockEntities;
            return;
        }
        if (blockEntity instanceof Cullable) {
            Cullable cullable = (Cullable)blockEntity;
            if (!cullable.isForcedVisible() && cullable.isCulled()) {
                ++EntityCullingModBase.instance.skippedBlockEntities;
                info.setReturnValue(null);
                return;
            }
            ++EntityCullingModBase.instance.renderedBlockEntities;
            cullable.setOutOfCamera(false);
        }
    }

    @Shadow
    public abstract <E extends BlockEntity> BlockEntityRenderer getRenderer(E var1);
}

