/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common;

import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.IToolConfiguration;
import fr.rakambda.fallingtree.common.config.proxy.ProxyConfiguration;
import fr.rakambda.fallingtree.common.config.real.Configuration;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingHandler;
import fr.rakambda.fallingtree.common.network.PacketUtils;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.common.tree.TreeHandler;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.builder.TreeBuilder;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockBreakEvent;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public abstract class FallingTreeCommon<D extends Enum<D>> {
    private final Configuration ownConfiguration;
    private final ProxyConfiguration proxyConfiguration;
    private final TreeBuilder treeBuilder;
    private final TreeHandler treeHandler;
    private final PacketUtils packetUtils;

    public FallingTreeCommon() {
        this.ownConfiguration = Configuration.read();
        this.proxyConfiguration = new ProxyConfiguration(this.ownConfiguration);
        this.treeBuilder = new TreeBuilder(this);
        this.treeHandler = new TreeHandler(this);
        this.packetUtils = new PacketUtils(this);
    }

    public IConfiguration getConfiguration() {
        return this.getProxyConfiguration();
    }

    public abstract @NonNull IComponent translate(@NonNull String var1, Object ... var2);

    public void notifyPlayer(@NonNull IPlayer player, @NonNull IComponent component) {
        player.sendMessage(component, this.getConfiguration().getNotificationMode());
    }

    public boolean checkForceToolUsage(@NonNull IPlayer player, @NonNull ILevel level, @NonNull IBlockPos blockPos) {
        if (!this.getConfiguration().getTools().isForceToolUsage()) {
            return true;
        }
        IBlock originBlock = level.getBlockState(blockPos).getBlock();
        if (!this.isLogBlock(originBlock)) {
            return true;
        }
        return this.isValidTool(player.getMainHandItem());
    }

    public boolean isPlayerInRightState(@NonNull IPlayer player) {
        if (player.isCreative() && !this.getConfiguration().isBreakInCreative()) {
            return false;
        }
        if (!this.getConfiguration().getSneakMode().test(player.isCrouching())) {
            return false;
        }
        if (this.playerHasToggledOff(player)) {
            return false;
        }
        if (!this.playerHasRequiredTags(player)) {
            return false;
        }
        return this.canPlayerBreakTree(player);
    }

    private boolean playerHasToggledOff(@NonNull IPlayer player) {
        return player.getTags().contains("fallingtree-disabled");
    }

    private boolean playerHasRequiredTags(@NonNull IPlayer player) {
        List<String> tags = this.getConfiguration().getPlayer().getAllowedTagsNormalized();
        if (tags.isEmpty()) {
            return true;
        }
        Set<String> playerTags = player.getTags();
        return tags.stream().anyMatch(playerTags::contains);
    }

    public boolean canPlayerBreakTree(@NonNull IPlayer player) {
        IItemStack heldItemStack = player.getMainHandItem();
        if (!this.isValidTool(heldItemStack)) {
            return false;
        }
        return !this.getConfiguration().getEnchantment().isRequireEnchantment() || heldItemStack.hasChopperEnchant();
    }

    public boolean isValidTool(@NonNull IItemStack heldItemStack) {
        boolean isAllowedTool;
        IToolConfiguration toolConfiguration = this.getConfiguration().getTools();
        IItem heldItem = heldItemStack.getItem();
        boolean bl = isAllowedTool = toolConfiguration.isIgnoreTools() || heldItem.isAxe() || toolConfiguration.getAllowedItems(this).stream().anyMatch(tool -> tool.equals(heldItem)) || heldItemStack.canPerformAxeAction();
        if (!isAllowedTool) {
            return false;
        }
        boolean isDeniedTool = toolConfiguration.getDeniedItems(this).stream().anyMatch(tool -> tool.equals(heldItem));
        return !isDeniedTool;
    }

    public @NonNull TreeHandler getTreeHandler() {
        return this.treeHandler;
    }

    public @NonNull TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public abstract @NonNull LeafBreakingHandler getLeafBreakingHandler();

    public abstract @NonNull ServerPacketHandler getServerPacketHandler();

    public @NonNull Set<IBlock> getAsBlocks(@NonNull Collection<String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(this::getBlock).filter(Objects::nonNull).filter(block -> !block.isAir()).collect(Collectors.toSet());
    }

    public abstract @NonNull Stream<IBlock> getBlock(@NonNull String var1);

    public @NonNull Set<IItem> getAsItems(Collection<String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(this::getItem).filter(Objects::nonNull).filter(item -> !item.isAir()).collect(Collectors.toSet());
    }

    public abstract @NonNull Stream<IItem> getItem(@NonNull String var1);

    public abstract boolean isLeafBlock(@NonNull IBlock var1);

    public abstract boolean isLogBlock(@NonNull IBlock var1);

    public abstract @NonNull Set<IBlock> getAllNonStrippedLogsBlocks();

    public abstract @NonNull DirectionCompat asDirectionCompat(@NonNull D var1);

    public abstract @NonNull D asDirection(@NonNull DirectionCompat var1);

    public boolean isLeafNeedBreakBlock(@NonNull IBlock block) {
        return this.getConfiguration().getTrees().getAllowedNonDecayLeaveBlocks(this).stream().anyMatch(log -> log.equals(block));
    }

    public abstract boolean isNetherWartOrShroomlight(@NonNull IBlock var1);

    public abstract boolean isMangroveRoots(@NonNull IBlock var1);

    public @NonNull TreePartType getTreePart(@NonNull IBlock checkBlock) {
        if (this.isLogBlock(checkBlock)) {
            return TreePartType.LOG;
        }
        if (this.isNetherWartOrShroomlight(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (this.isMangroveRoots(checkBlock)) {
            return TreePartType.MANGROVE_ROOTS;
        }
        if (this.isLeafNeedBreakBlock(checkBlock)) {
            return TreePartType.LEAF_NEED_BREAK;
        }
        if (this.isLeafBlock(checkBlock)) {
            return TreePartType.LEAF;
        }
        return TreePartType.OTHER;
    }

    public abstract boolean checkCanBreakBlock(@NonNull ILevel var1, @NonNull IBlockPos var2, @NonNull IBlockState var3, @NonNull IPlayer var4);

    public abstract @NonNull IItemStack getEmptyItemStack();

    public boolean isOwnEvent(@NonNull IBlockBreakEvent event) {
        return false;
    }

    public abstract void onConfigUpdate();

    @Generated
    public FallingTreeCommon(Configuration ownConfiguration, ProxyConfiguration proxyConfiguration, TreeBuilder treeBuilder, TreeHandler treeHandler, PacketUtils packetUtils) {
        this.ownConfiguration = ownConfiguration;
        this.proxyConfiguration = proxyConfiguration;
        this.treeBuilder = treeBuilder;
        this.treeHandler = treeHandler;
        this.packetUtils = packetUtils;
    }

    @Generated
    public Configuration getOwnConfiguration() {
        return this.ownConfiguration;
    }

    @Generated
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Generated
    public PacketUtils getPacketUtils() {
        return this.packetUtils;
    }
}

