/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.real;

import com.google.gson.annotations.Expose;
import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.config.enums.SneakMode;
import fr.rakambda.fallingtree.common.config.real.ConfigLoader;
import fr.rakambda.fallingtree.common.config.real.EnchantmentConfiguration;
import fr.rakambda.fallingtree.common.config.real.PlayerConfiguration;
import fr.rakambda.fallingtree.common.config.real.ToolConfiguration;
import fr.rakambda.fallingtree.common.config.real.TreeConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class Configuration
implements IConfiguration {
    @Generated
    private static final Logger log = LogManager.getLogger(Configuration.class);
    @Expose
    private @NonNull TreeConfiguration trees = new TreeConfiguration();
    @Expose
    private @NonNull ToolConfiguration tools = new ToolConfiguration();
    @Expose
    private @NonNull PlayerConfiguration player = new PlayerConfiguration();
    @Expose
    private @NonNull EnchantmentConfiguration enchantment = new EnchantmentConfiguration();
    @Expose
    private @NonNull SneakMode sneakMode = SneakMode.SNEAK_DISABLE;
    @Expose
    private boolean breakInCreative = false;
    @Expose
    private boolean lootInCreative = true;
    @Expose
    private @NonNull NotificationMode notificationMode = NotificationMode.ACTION_BAR;

    public static Configuration read() throws RuntimeException {
        Path path = Configuration.getConfigPath();
        try {
            return ConfigLoader.loadConfig(new Configuration(), Configuration.class, path);
        }
        catch (IOException e) {
            log.error("Failed to get FallingTree configuration from {}, using default", (Object)path, (Object)e);
            return new Configuration();
        }
    }

    public void onUpdate() {
        this.trees.reset();
        this.tools.reset();
        this.player.reset();
        Path path = Configuration.getConfigPath();
        try {
            ConfigLoader.saveConfig(this, path);
        }
        catch (IOException e) {
            log.error("Failed to save FallingTree configuration to {}", (Object)path, (Object)e);
        }
    }

    private static Path getConfigPath() {
        return Paths.get(".", new String[0]).resolve("config").resolve("fallingtree.json");
    }

    @Generated
    private Configuration() {
    }

    @Override
    @Generated
    public @NonNull TreeConfiguration getTrees() {
        return this.trees;
    }

    @Override
    @Generated
    public @NonNull ToolConfiguration getTools() {
        return this.tools;
    }

    @Override
    @Generated
    public @NonNull PlayerConfiguration getPlayer() {
        return this.player;
    }

    @Override
    @Generated
    public @NonNull EnchantmentConfiguration getEnchantment() {
        return this.enchantment;
    }

    @Override
    @Generated
    public @NonNull SneakMode getSneakMode() {
        return this.sneakMode;
    }

    @Override
    @Generated
    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    @Override
    @Generated
    public boolean isLootInCreative() {
        return this.lootInCreative;
    }

    @Override
    @Generated
    public @NonNull NotificationMode getNotificationMode() {
        return this.notificationMode;
    }

    @Generated
    public void setTrees(@NonNull TreeConfiguration trees) {
        if (trees == null) {
            throw new NullPointerException("trees is marked non-null but is null");
        }
        this.trees = trees;
    }

    @Generated
    public void setTools(@NonNull ToolConfiguration tools) {
        if (tools == null) {
            throw new NullPointerException("tools is marked non-null but is null");
        }
        this.tools = tools;
    }

    @Generated
    public void setPlayer(@NonNull PlayerConfiguration player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }

    @Generated
    public void setEnchantment(@NonNull EnchantmentConfiguration enchantment) {
        if (enchantment == null) {
            throw new NullPointerException("enchantment is marked non-null but is null");
        }
        this.enchantment = enchantment;
    }

    @Generated
    public void setSneakMode(@NonNull SneakMode sneakMode) {
        if (sneakMode == null) {
            throw new NullPointerException("sneakMode is marked non-null but is null");
        }
        this.sneakMode = sneakMode;
    }

    @Generated
    public void setBreakInCreative(boolean breakInCreative) {
        this.breakInCreative = breakInCreative;
    }

    @Generated
    public void setLootInCreative(boolean lootInCreative) {
        this.lootInCreative = lootInCreative;
    }

    @Generated
    public void setNotificationMode(@NonNull NotificationMode notificationMode) {
        if (notificationMode == null) {
            throw new NullPointerException("notificationMode is marked non-null but is null");
        }
        this.notificationMode = notificationMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBreakInCreative() != other.isBreakInCreative()) {
            return false;
        }
        if (this.isLootInCreative() != other.isLootInCreative()) {
            return false;
        }
        TreeConfiguration this$trees = this.getTrees();
        TreeConfiguration other$trees = other.getTrees();
        if (this$trees == null ? other$trees != null : !((Object)this$trees).equals(other$trees)) {
            return false;
        }
        ToolConfiguration this$tools = this.getTools();
        ToolConfiguration other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        PlayerConfiguration this$player = this.getPlayer();
        PlayerConfiguration other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        EnchantmentConfiguration this$enchantment = this.getEnchantment();
        EnchantmentConfiguration other$enchantment = other.getEnchantment();
        if (this$enchantment == null ? other$enchantment != null : !((Object)this$enchantment).equals(other$enchantment)) {
            return false;
        }
        SneakMode this$sneakMode = this.getSneakMode();
        SneakMode other$sneakMode = other.getSneakMode();
        if (this$sneakMode == null ? other$sneakMode != null : !((Object)((Object)this$sneakMode)).equals((Object)other$sneakMode)) {
            return false;
        }
        NotificationMode this$notificationMode = this.getNotificationMode();
        NotificationMode other$notificationMode = other.getNotificationMode();
        return !(this$notificationMode == null ? other$notificationMode != null : !((Object)((Object)this$notificationMode)).equals((Object)other$notificationMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBreakInCreative() ? 79 : 97);
        result = result * 59 + (this.isLootInCreative() ? 79 : 97);
        TreeConfiguration $trees = this.getTrees();
        result = result * 59 + ($trees == null ? 43 : ((Object)$trees).hashCode());
        ToolConfiguration $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        PlayerConfiguration $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        EnchantmentConfiguration $enchantment = this.getEnchantment();
        result = result * 59 + ($enchantment == null ? 43 : ((Object)$enchantment).hashCode());
        SneakMode $sneakMode = this.getSneakMode();
        result = result * 59 + ($sneakMode == null ? 43 : ((Object)((Object)$sneakMode)).hashCode());
        NotificationMode $notificationMode = this.getNotificationMode();
        result = result * 59 + ($notificationMode == null ? 43 : ((Object)((Object)$notificationMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Configuration(trees=" + String.valueOf(this.getTrees()) + ", tools=" + String.valueOf(this.getTools()) + ", player=" + String.valueOf(this.getPlayer()) + ", enchantment=" + String.valueOf(this.getEnchantment()) + ", sneakMode=" + String.valueOf((Object)this.getSneakMode()) + ", breakInCreative=" + this.isBreakInCreative() + ", lootInCreative=" + this.isLootInCreative() + ", notificationMode=" + String.valueOf((Object)this.getNotificationMode()) + ")";
    }
}

