/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.sailing;

import com.cursee.monolib.impl.common.sailing.SailingEntry;
import com.cursee.monolib.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;

public class SailingImpl {
    public static final Map<String, String> FILENAME_TO_MOD_NAME = new HashMap<String, String>();
    public static final Map<String, SailingEntry> MOD_NAME_TO_ENTRY = new HashMap<String, SailingEntry>();
    public static boolean verified = true;

    @ApiStatus.Internal
    public static void register(String modID, String modName, String modVersion, String modPublisher, String modURL) {
        String expectedFilename = modID + "-merged-" + Services.PLATFORM.getGameVersion() + "-" + modVersion + ".jar";
        FILENAME_TO_MOD_NAME.put(expectedFilename, modName);
        MOD_NAME_TO_ENTRY.put(modName, new SailingEntry(modID, modName, modVersion, modPublisher, modURL));
    }

    public static boolean preVerificationProcess() {
        String checkFilePathString = Services.PLATFORM.getGameDirectoryString() + File.separator + "config" + File.separator + "monolib" + File.separator + "checked.txt";
        File checkFile = new File(checkFilePathString);
        if (checkFile.exists()) {
            verified = true;
        }
        return verified;
    }

    public static void postVerificationProcess() {
        verified = true;
        Object alternativePath = Services.PLATFORM.getGameDirectoryString();
        if (new File((String)(alternativePath = (String)alternativePath + File.separator + "config" + File.separator + "monolib") + File.separator + "checked.txt").isFile()) {
            return;
        }
        File alternativeDirectory = new File((String)alternativePath);
        if (!alternativeDirectory.mkdirs()) {
            return;
        }
        try (PrintWriter writer = new PrintWriter((String)alternativePath + File.separator + "checked.txt", StandardCharsets.UTF_8);){
            writer.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer.println("checked=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getModNamesMissingJarFile() {
        List<String> INSTALLED_MOD_FILENAMES = SailingImpl.getInstalledModFilenames();
        ArrayList<String> MOD_NAMES_MISSING_JAR_FILE = new ArrayList<String>();
        for (String filename : FILENAME_TO_MOD_NAME.keySet()) {
            boolean CONTAINS_MERGED = INSTALLED_MOD_FILENAMES.contains(filename);
            boolean CONTAINS_FABRIC = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-fabric-"));
            boolean CONTAINS_FORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-forge-"));
            boolean CONTAINS_NEOFORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-neoforge-"));
            if (INSTALLED_MOD_FILENAMES.isEmpty() || CONTAINS_MERGED || CONTAINS_FABRIC || CONTAINS_FORGE || CONTAINS_NEOFORGE || !FILENAME_TO_MOD_NAME.containsKey(filename)) continue;
            MOD_NAMES_MISSING_JAR_FILE.add(FILENAME_TO_MOD_NAME.get(filename));
        }
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty()) {
            Collections.sort(MOD_NAMES_MISSING_JAR_FILE);
        }
        return MOD_NAMES_MISSING_JAR_FILE;
    }

    private static List<String> getInstalledModFilenames() {
        ArrayList<String> INSTALLED_MOD_FILENAMES = new ArrayList<String>();
        File MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectoryString() + File.separator + "mods");
        Object[] DISCOVERED_FILES = MOD_DIRECTORY.listFiles();
        File VERSIONED_MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectoryString() + File.separator + "mods" + File.separator + Services.PLATFORM.getGameVersion());
        Object[] DISCOVERED_VERSIONED_FILES = VERSIONED_MOD_DIRECTORY.listFiles();
        if (DISCOVERED_FILES == null && DISCOVERED_VERSIONED_FILES == null) {
            return new ArrayList<String>();
        }
        for (File file : (File[])ArrayUtils.addAll((Object[])DISCOVERED_FILES, (Object[])DISCOVERED_VERSIONED_FILES)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            INSTALLED_MOD_FILENAMES.add(filename);
        }
        return INSTALLED_MOD_FILENAMES;
    }
}

