/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.net.ClientNetworking;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageOpenHistory
implements Message<MessageOpenHistory> {
    public static final CustomPacketPayload.Type<MessageOpenHistory> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"corpse", (String)"open_history"));
    private List<Death> deaths;

    public MessageOpenHistory() {
    }

    public MessageOpenHistory(List<Death> deaths) {
        this.deaths = deaths;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        ClientNetworking.openCorpseHistory(this.deaths);
    }

    @Override
    public MessageOpenHistory fromBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag compound = buf.readNbt();
        ListTag list = compound.getListOrEmpty("Deaths");
        this.deaths = new ArrayList<Death>();
        for (int i = 0; i < list.size(); ++i) {
            list.getCompound(i).ifPresent(e -> this.deaths.add(Death.read((HolderLookup.Provider)buf.registryAccess(), e)));
        }
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (Death d : this.deaths) {
            CompoundTag c = d.write((HolderLookup.Provider)buf.registryAccess(), false);
            list.add((Object)c);
        }
        compound.put("Deaths", (Tag)list);
        buf.writeNbt((Tag)compound);
    }

    @Override
    public CustomPacketPayload.Type<MessageOpenHistory> type() {
        return TYPE;
    }
}

