/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Channel;
import de.maxhenkel.voicechat.net.ClientServerChannel;
import de.maxhenkel.voicechat.net.NeoForgeClientNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetManager
extends NetManager {
    private List<PacketRegister> packets = new ArrayList<PacketRegister>();

    @Override
    public void init() {
        this.packets.clear();
        super.init();
    }

    @SubscribeEvent
    public <T extends Packet<T>> void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("voicechat").optional();
        for (PacketRegister register : this.packets) {
            this.register(registrar, register.channel(), register.packetClass(), register.toClient(), register.toServer());
        }
    }

    private <T extends Packet<T>> void register(PayloadRegistrar registrar, ClientServerChannel<T> channel, final Class<T> packetType, boolean toClient, boolean toServer) {
        try {
            Packet dummyPacket = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StreamCodec codec = new StreamCodec<RegistryFriendlyByteBuf, T>(this){

                public void encode(RegistryFriendlyByteBuf buf, T packet) {
                    packet.toBytes((FriendlyByteBuf)buf);
                }

                public T decode(RegistryFriendlyByteBuf buf) {
                    try {
                        Packet packet = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes((FriendlyByteBuf)buf);
                        return packet;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            IPayloadHandler handler = (payload, context) -> context.enqueueWork(() -> {
                if (toServer && context.flow().equals((Object)PacketFlow.SERVERBOUND)) {
                    Player patt0$temp = context.player();
                    if (!(patt0$temp instanceof ServerPlayer)) {
                        return;
                    }
                    ServerPlayer sender = (ServerPlayer)patt0$temp;
                    try {
                        if (!Voicechat.SERVER.isCompatible(sender) && !packetType.equals(RequestSecretPacket.class)) {
                            return;
                        }
                        channel.onServerPacket(sender, payload);
                    }
                    catch (Exception e) {
                        Voicechat.LOGGER.error("Failed to process packet", e);
                    }
                } else {
                    Player patt0$temp = context.player();
                    if (!(patt0$temp instanceof LocalPlayer)) {
                        return;
                    }
                    LocalPlayer player = (LocalPlayer)patt0$temp;
                    try {
                        NeoForgeClientNetManager.onClientPacket(player, channel, payload);
                    }
                    catch (Exception e) {
                        Voicechat.LOGGER.error("Failed to process packet", e);
                    }
                }
            });
            if (toClient && toServer) {
                registrar.playBidirectional(dummyPacket.type(), codec, handler);
            } else if (toClient) {
                registrar.playToClient(dummyPacket.type(), codec, handler);
            } else if (toServer) {
                registrar.playToServer(dummyPacket.type(), codec, handler);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T extends Packet<T>> Channel<T> registerReceiver(Class<T> packetType, boolean toClient, boolean toServer) {
        ClientServerChannel c = new ClientServerChannel();
        this.packets.add(new PacketRegister<T>(packetType, c, toClient, toServer));
        return c;
    }

    @Override
    protected void sendToServerInternal(Packet<?> packet) {
        try {
            ClientPacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (UnsupportedOperationException e) {
            if (Voicechat.debugMode()) {
                Voicechat.LOGGER.warn("Server does not accept voice chat packets", e);
            }
            Voicechat.LOGGER.warn("Server does not accept voice chat packets", new Object[0]);
        }
    }

    @Override
    public void sendToClient(Packet<?> packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    record PacketRegister<T extends Packet<T>>(Class<T> packetClass, ClientServerChannel<T> channel, boolean toClient, boolean toServer) {
    }
}

