/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.HorizontalSlabConverter;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.converter.VerticalSlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockBreakHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean onBreakBlock(LevelAccessor level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Player player) {
        BlockState newState;
        BlockState dropState;
        SlabConverter slabConverter;
        Vec3 hitVec;
        if (Balm.hooks().isFakePlayer(player)) {
            return true;
        }
        if (!KleeSlabs.isPlayerKleeSlabbing(player)) {
            return true;
        }
        double blockReachDistance = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        BlockHitResult rayTraceResult = BlockBreakHandler.rayTrace((LivingEntity)player, blockReachDistance);
        Direction hitSide = rayTraceResult.getDirection();
        Vec3 vec3 = hitVec = rayTraceResult.getType() == HitResult.Type.BLOCK ? rayTraceResult.getLocation() : null;
        if (hitVec != null) {
            hitVec = hitVec.add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        }
        if ((slabConverter = (SlabConverter)SlabRegistry.getSlabConverter(state).orElse(null)) == null || !slabConverter.isDoubleSlab(state)) {
            return true;
        }
        if (slabConverter instanceof HorizontalSlabConverter) {
            SlabType stay;
            SlabType hit;
            HorizontalSlabConverter horizontalSlabConverter = (HorizontalSlabConverter)slabConverter;
            if (hitVec != null && hitVec.y > 0.5) {
                hit = SlabType.TOP;
                stay = SlabType.BOTTOM;
            } else {
                stay = SlabType.TOP;
                hit = SlabType.BOTTOM;
            }
            dropState = horizontalSlabConverter.getSingleSlab(state, level, pos, player, hit);
            newState = horizontalSlabConverter.getSingleSlab(state, level, pos, player, stay);
        } else {
            if (!(slabConverter instanceof VerticalSlabConverter)) return true;
            VerticalSlabConverter verticalSlabConverter = (VerticalSlabConverter)slabConverter;
            if (hitSide.getAxis() == Direction.Axis.Y) return true;
            dropState = verticalSlabConverter.getSingleSlab(state, level, pos, player, hitSide.getOpposite());
            newState = verticalSlabConverter.getSingleSlab(state, level, pos, player, hitSide);
        }
        if (level instanceof ServerLevel) {
            Item slabItem;
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.hasCorrectToolForDrops(dropState) && !player.getAbilities().instabuild && (slabItem = Item.byBlock((Block)dropState.getBlock())) != Items.AIR) {
                ItemStack itemStack = new ItemStack((ItemLike)slabItem);
                float scale = 0.7f;
                double xOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
                double yOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
                double zOffset = (double)(level.getRandom().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
                ItemEntity entityItem = new ItemEntity((Level)serverLevel, (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, itemStack);
                entityItem.setPickUpDelay(10);
                level.addFreshEntity((Entity)entityItem);
            }
        }
        level.setBlock(pos, newState, 3);
        return false;
    }

    public static BlockHitResult rayTrace(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 endPos = startPos.add(entity.getLookAngle().x * length, entity.getLookAngle().y * length, entity.getLookAngle().z * length);
        ClipContext rayTraceContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(rayTraceContext);
    }
}

