/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabDumpHandler {
    private static final Logger log = LoggerFactory.getLogger(SlabDumpHandler.class);

    public static void onServerStarted(MinecraftServer server) {
        if (KleeSlabsConfig.getActive().dumpSlabs) {
            SlabDumpHandler.dumpSlabs();
        }
    }

    public static void dumpSlabs() {
        String slabsOutput;
        Map<String, List<Identifier>> slabsByMod = BuiltInRegistries.BLOCK.keySet().stream().filter(itemName -> itemName.getPath().endsWith("_slab") && !itemName.getPath().contains("vertical")).collect(Collectors.groupingBy(Identifier::getNamespace));
        Map<String, List<Identifier>> verticalSlabsByMod = BuiltInRegistries.BLOCK.keySet().stream().filter(itemName -> itemName.getPath().endsWith("_slab") && itemName.getPath().contains("vertical")).collect(Collectors.groupingBy(Identifier::getNamespace));
        for (Map.Entry<String, List<Identifier>> slabs : slabsByMod.entrySet()) {
            slabsOutput = slabs.getValue().stream().map(Identifier::getPath).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Slabs from mod {}:\n{}", (Object)slabs.getKey(), (Object)slabsOutput);
        }
        for (Map.Entry<String, List<Identifier>> verticalSlabs : verticalSlabsByMod.entrySet()) {
            slabsOutput = verticalSlabs.getValue().stream().map(Identifier::getPath).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Vertical slabs from mod {}:\n{}", (Object)verticalSlabs.getKey(), (Object)slabsOutput);
        }
    }
}

