/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class ContentsFilteredItemHandler
implements ITrackedContentsItemResourceHandler {
    private final Supplier<ITrackedContentsItemResourceHandler> itemHandlerGetter;
    private final Supplier<ISlotTracker> slotTrackerGetter;
    private final Supplier<MemorySettingsCategory> memorySettingsGetter;

    public ContentsFilteredItemHandler(Supplier<ITrackedContentsItemResourceHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
        this.itemHandlerGetter = itemHandlerGetter;
        this.slotTrackerGetter = slotTrackerGetter;
        this.memorySettingsGetter = memorySettingsGetter;
    }

    public int size() {
        return this.itemHandlerGetter.get().size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemHandlerGetter.get().getStackInSlot(slot);
    }

    public ItemResource getResource(int index) {
        return (ItemResource)this.itemHandlerGetter.get().getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.itemHandlerGetter.get().getAmountAsLong(index);
    }

    public int insert(ItemResource resource, int amount, TransactionContext tx) {
        if (this.matchesContents(resource)) {
            return this.itemHandlerGetter.get().insert((Resource)resource, amount, tx);
        }
        return 0;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext tx) {
        if (this.matchesContents(resource)) {
            return this.itemHandlerGetter.get().insert(index, (Resource)resource, amount, tx);
        }
        return 0;
    }

    public int extract(ItemResource resource, int amount, TransactionContext tx) {
        return this.itemHandlerGetter.get().extract((Resource)resource, amount, tx);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext tx) {
        return this.itemHandlerGetter.get().extract(index, (Resource)resource, amount, tx);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        return this.itemHandlerGetter.get().getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.matchesContents(resource) && this.itemHandlerGetter.get().isValid(index, (Resource)resource);
    }

    private boolean matchesContents(ItemResource resource) {
        return this.slotTrackerGetter.get().getItems().contains(resource.getItem()) || this.memorySettingsGetter.get().matchesFilter(resource);
    }

    public Set<ItemStackKey> getTrackedStacks() {
        return this.itemHandlerGetter.get().getTrackedStacks();
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    public void unregisterStackKeyListeners() {
        this.itemHandlerGetter.get().unregisterStackKeyListeners();
    }

    public boolean hasEmptySlots() {
        return this.itemHandlerGetter.get().hasEmptySlots();
    }

    public int getInternalSlotLimit(int slot) {
        return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.itemHandlerGetter.get().setStackInSlot(slot, stack);
    }
}

