/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;

public class ItemContentsStorage
extends SavedData {
    private static final SavedDataType<ItemContentsStorage> TYPE = new SavedDataType("sophisticatedstorage", ItemContentsStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_UUID, (Codec)ContainerContents.CODEC).fieldOf("storageContents").forGetter(storage -> storage.storageContents), (App)Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_UUID, (Codec)CompoundTag.CODEC).fieldOf("additionalBeData").forGetter(storage -> storage.additionalBeData)).apply((Applicative)builder, ItemContentsStorage::new)));
    private final Map<UUID, ContainerContents> storageContents = new HashMap<UUID, ContainerContents>();
    private final Map<UUID, CompoundTag> additionalBeData = new HashMap<UUID, CompoundTag>();
    private static final ItemContentsStorage clientStorageCopy = new ItemContentsStorage();

    private ItemContentsStorage(Map<UUID, ContainerContents> storageContents, Map<UUID, CompoundTag> additionalBeData) {
        this.storageContents.putAll(storageContents);
        this.additionalBeData.putAll(additionalBeData);
    }

    private ItemContentsStorage() {
    }

    public static ItemContentsStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (ItemContentsStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public boolean has(UUID storageUuid) {
        return this.additionalBeData.containsKey(storageUuid);
    }

    public CompoundTag getOrCreateAddtionalBeData(UUID storageUuid) {
        return this.additionalBeData.computeIfAbsent(storageUuid, uuid -> {
            this.setDirty();
            return new CompoundTag();
        });
    }

    public void removeAddtionalBeData(UUID storageUuid) {
        this.additionalBeData.remove(storageUuid);
        this.setDirty();
    }

    public void setAdditionalBeData(UUID storageUuid, CompoundTag contents) {
        this.additionalBeData.put(storageUuid, contents);
        this.setDirty();
    }

    public ContainerContents getOrCreateContents(UUID storageUuid) {
        return this.storageContents.computeIfAbsent(storageUuid, uuid -> {
            this.setDirty();
            return new ContainerContents();
        });
    }

    public void removeContents(UUID storageUuid) {
        this.storageContents.remove(storageUuid);
        this.setDirty();
    }

    public void setContents(UUID storageUuid, ContainerContents contents) {
        this.storageContents.put(storageUuid, contents);
        this.setDirty();
    }
}

