/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class StorageConnectorBlockEntity
extends BlockEntity
implements IControllerBoundable {
    private @Nullable BlockPos controllerPos = null;
    private boolean chunkBeingUnloaded = false;

    public StorageConnectorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.STORAGE_CONNECTOR_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.setChanged();
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return this.getLevel();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.getBlockPos());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public boolean canConnectStorages() {
        return true;
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        this.saveControllerPos(out);
    }

    public void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.loadControllerPos(in);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.chunkBeingUnloaded && this.level != null) {
            this.removeFromController();
        }
        super.setRemoved();
    }

    public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public void removeFromController() {
        if (this.controllerPos != null && !this.level.isClientSide()) {
            WorldHelper.getBlockEntity((BlockGetter)this.level, (BlockPos)this.controllerPos, ControllerBlockEntityBase.class).ifPresent(controller -> controller.removeBoundable(this.worldPosition));
            this.removeControllerPos();
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.removeFromController();
    }
}

