/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PackingTapeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jspecify.annotations.Nullable;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Map<WoodType, BlockFamily> CUSTOM_TEXTURE_WOOD_TYPES = ImmutableMap.builder().put((Object)WoodType.ACACIA, (Object)BlockFamilies.ACACIA_PLANKS).put((Object)WoodType.BIRCH, (Object)BlockFamilies.BIRCH_PLANKS).put((Object)WoodType.CRIMSON, (Object)BlockFamilies.CRIMSON_PLANKS).put((Object)WoodType.DARK_OAK, (Object)BlockFamilies.DARK_OAK_PLANKS).put((Object)WoodType.JUNGLE, (Object)BlockFamilies.JUNGLE_PLANKS).put((Object)WoodType.OAK, (Object)BlockFamilies.OAK_PLANKS).put((Object)WoodType.PALE_OAK, (Object)BlockFamilies.PALE_OAK_PLANKS).put((Object)WoodType.SPRUCE, (Object)BlockFamilies.SPRUCE_PLANKS).put((Object)WoodType.WARPED, (Object)BlockFamilies.WARPED_PLANKS).put((Object)WoodType.MANGROVE, (Object)BlockFamilies.MANGROVE_PLANKS).put((Object)WoodType.CHERRY, (Object)BlockFamilies.CHERRY_PLANKS).put((Object)WoodType.BAMBOO, (Object)BlockFamilies.BAMBOO_PLANKS).build();

    protected WoodStorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
                if (WoodStorageBlockBase.isNonEmpty(wbe)) {
                    wbe.setPacked(true);
                }
            });
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked() || WoodStorageBlockBase.shouldNonEmptyDropPacked(wbe)) {
                wbe.setPacked(true);
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                CompoundTag additionalBeData = this.getStorageAdditionalData(be);
                ContainerContents contents = storageWrapper.getContents().copy();
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                itemContentsStorage.setContents(storageUuid, contents);
                if (!additionalBeData.isEmpty()) {
                    itemContentsStorage.setAdditionalBeData(storageUuid, additionalBeData);
                    stack.set(ModCoreDataComponents.STORAGE_UUID, (Object)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
                StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
                StorageBlockItem.setNumberOfInventorySlots(stack, storageWrapper.getInventoryHandler().size());
                StorageBlockItem.setNumberOfUpgradeSlots(stack, storageWrapper.getUpgradeHandler().size());
            }
        }
    }

    protected CompoundTag getStorageAdditionalData(StorageBlockEntity be) {
        CompoundTag additionalBeData = be.saveWithoutMetadata((HolderLookup.Provider)be.getLevel().registryAccess());
        additionalBeData.getCompound("storageWrapper").ifPresent(tag -> tag.remove("contents"));
        additionalBeData.remove("controllerPos");
        additionalBeData.remove("packed");
        return additionalBeData;
    }

    private static boolean shouldNonEmptyDropPacked(WoodStorageBlockEntity wbe) {
        if (!((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
            return false;
        }
        return WoodStorageBlockBase.isNonEmpty(wbe);
    }

    private static boolean isNonEmpty(WoodStorageBlockEntity wbe) {
        if (!ResourceHandlerUtil.isEmpty((ResourceHandler)wbe.getStorageWrapper().getInventoryHandler())) {
            return true;
        }
        return !ResourceHandlerUtil.isEmpty((ResourceHandler)wbe.getStorageWrapper().getUpgradeHandler());
    }

    private void addNameWoodAndTintData(ItemStack stack, WoodStorageBlockEntity wbe) {
        Item item = stack.getItem();
        if (item instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor != -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) != -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        if (wbe.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)wbe.getCustomName());
        }
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (!Config.CLIENT_SPEC.isLoaded() || ((Boolean)Config.CLIENT.showSingleWoodVariantOnly.get()).booleanValue()) {
            itemConsumer.accept(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), WoodType.ACACIA));
        } else {
            CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> itemConsumer.accept(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), woodType)));
        }
        if (this.isBasicTier() || !Config.CLIENT_SPEC.isLoaded() || ((Boolean)Config.CLIENT.showHigherTierTintedVariants.get()).booleanValue()) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack storageStack = new ItemStack((ItemLike)this);
                Item item = storageStack.getItem();
                if (item instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                    tintableBlockItem.setMainColor(storageStack, color.getTextureDiffuseColor());
                    tintableBlockItem.setAccentColor(storageStack, color.getTextureDiffuseColor());
                }
                itemConsumer.accept(storageStack);
            }
            ItemStack storageStack = new ItemStack((ItemLike)this);
            Item item = storageStack.getItem();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.setMainColor(storageStack, DyeColor.YELLOW.getTextureDiffuseColor());
                tintableBlockItem.setAccentColor(storageStack, DyeColor.LIME.getTextureDiffuseColor());
            }
            itemConsumer.accept(storageStack);
        }
    }

    private boolean isBasicTier() {
        return this == ModBlocks.BARREL.get() || this == ModBlocks.CHEST.get() || this == ModBlocks.LIMITED_BARREL_1.get() || this == ModBlocks.LIMITED_BARREL_2.get() || this == ModBlocks.LIMITED_BARREL_3.get() || this == ModBlocks.LIMITED_BARREL_4.get();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = new ItemStack((ItemLike)this);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            if (includeData) {
                this.addDropData(stack, (StorageBlockEntity)be);
            } else {
                this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)be);
            }
        });
        return stack;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.isClientSide()) {
            return;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            UUID storageUuid = (UUID)stack.get(ModCoreDataComponents.STORAGE_UUID);
            if (storageUuid != null) {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                if (itemContentsStorage.has(storageUuid)) {
                    be.setBeingUpgraded(true);
                    CompoundTag beTag = itemContentsStorage.getOrCreateAddtionalBeData(storageUuid);
                    ContainerContents contents = itemContentsStorage.getOrCreateContents(storageUuid);
                    Tag contentsTag = (Tag)ContainerContents.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)be.getLevel().registryAccess()), (Object)contents).getOrThrow();
                    beTag.getCompound("storageWrapper").ifPresent(tag -> tag.put("contents", contentsTag));
                    be.loadAdditional(ValueIOHelper.inputFromCompoundTag((HolderLookup.Provider)level.registryAccess(), (CompoundTag)beTag));
                    itemContentsStorage.removeContents(storageUuid);
                    itemContentsStorage.removeAddtionalBeData(storageUuid);
                    this.setNewSize(stack, (WoodStorageBlockEntity)be);
                    this.setTicking(level, pos, state, !be.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
                } else {
                    SophisticatedStorage.LOGGER.error("No storage contents found for uuid: " + String.valueOf(storageUuid) + " when placing " + stack.getHoverName().getString());
                }
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.setCustomName(stack.getHoverName());
            }
            this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.getOffhandItem().getItem() == ModItems.STORAGE_TOOL.get()) {
                StorageToolItem.useOffHandOnPlaced(placer.getOffhandItem(), be);
            }
            be.setBeingUpgraded(false);
        });
    }

    private void setNewSize(ItemStack stack, WoodStorageBlockEntity be) {
        StorageWrapper storageWrapper = be.getStorageWrapper();
        InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
        UpgradeHandler upgradeHandler = storageWrapper.getUpgradeHandler();
        storageWrapper.changeSize(StorageBlockItem.getNumberOfInventorySlots(stack) - inventoryHandler.size(), StorageBlockItem.getNumberOfUpgradeSlots(stack) - upgradeHandler.size());
    }

    protected void setRenderBlockRenderProperties(ItemStack stack, WoodStorageBlockEntity be) {
        WoodStorageBlockItem.getWoodType((DataComponentHolder)stack).ifPresent(be::setWoodType);
        be.getStorageWrapper().setColors(StorageBlockItem.getMainColorFromComponentHolder((DataComponentGetter)stack).orElse(-1), StorageBlockItem.getAccentColorFromComponentHolder((DataComponentGetter)stack).orElse(-1));
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState ret = super.playerWillDestroy(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue() && WoodStorageBlockBase.isNonEmpty(wbe)) {
                wbe.setPacked(true);
            }
            if (wbe.isPacked() && player.isCreative() && (!ResourceHandlerUtil.isEmpty((ResourceHandler)wbe.getStorageWrapper().getInventoryHandler()) || !ResourceHandlerUtil.isEmpty((ResourceHandler)wbe.getStorageWrapper().getUpgradeHandler()))) {
                ItemStack drop = new ItemStack((ItemLike)this);
                this.addDropData(drop, (StorageBlockEntity)wbe);
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
        });
        return ret;
    }

    protected InteractionResult tryItemInteraction(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (stackInHand.getItem() instanceof PackingTapeItem) {
            if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.sophisticatedstorage.status.packing_tape_disabled"), true);
                return InteractionResult.FAIL;
            }
            return this.packStorage(player, hand, b, stackInHand);
        }
        return this.tryAddUpgrade(player, b, stackInHand, facing, hitResult);
    }

    protected InteractionResult packStorage(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        BlockState blockState;
        Block block;
        if (!player.isCreative()) {
            stackInHand.setDamageValue(stackInHand.getDamageValue() + 1);
        }
        if ((block = (blockState = b.getBlockState()).getBlock()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            if (((Boolean)blockState.getValue((Property)StorageBlockBase.TICKING)).booleanValue()) {
                storageBlock.setTicking(player.level(), b.getBlockPos(), blockState, false);
            }
        }
        b.setPacked(true);
        b.removeFromController();
        WorldHelper.notifyBlockUpdate((BlockEntity)b);
        return InteractionResult.SUCCESS.heldItemTransformedTo(stackInHand.getDamageValue() >= stackInHand.getMaxDamage() ? ItemStack.EMPTY : stackInHand);
    }
}

