/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jspecify.annotations.Nullable;

public abstract class WoodStorageBlockEntity
extends StorageBlockEntity {
    public static final String PACKED = "packed";
    private @Nullable WoodType woodType = null;
    private boolean packed = false;

    protected WoodStorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
    }

    @Override
    protected void saveSynchronizedData(ValueOutput out) {
        super.saveSynchronizedData(out);
        if (this.woodType != null) {
            out.putString("woodType", this.woodType.name());
        }
        out.putBoolean(PACKED, this.packed);
    }

    @Override
    public void loadSynchronizedData(ValueInput in) {
        super.loadSynchronizedData(in);
        this.woodType = in.read("woodType", WoodType.CODEC).orElse(this.getStorageWrapper().hasMainColor() && this.getStorageWrapper().hasAccentColor() ? null : WoodType.ACACIA);
        this.packed = in.getBooleanOr(PACKED, false);
    }

    public Optional<WoodType> getWoodType() {
        return Optional.ofNullable(this.woodType);
    }

    public void setWoodType(WoodType woodType) {
        this.woodType = woodType;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.setChanged();
        }
    }

    @Override
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.makeWoodStorageDescriptionId(this.getWoodType().orElse(null));
    }

    private Component makeWoodStorageDescriptionId(@Nullable WoodType wt) {
        String id = Util.makeDescriptionId((String)"block", (Identifier)Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock())));
        return WoodStorageBlockItem.getDisplayName(id, wt);
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
        if (packed) {
            RenderDataHandler renderDataHandler = this.getStorageWrapper().getRenderDataHandler();
            renderDataHandler.removeAllUpgradeClientData();
        }
    }

    @Override
    public boolean shouldDropContents() {
        return !this.isPacked();
    }

    @Override
    public @Nullable ResourceHandler<ItemResource> getExternalItemHandler(@Nullable Direction side) {
        if (this.isPacked()) {
            return null;
        }
        return super.getExternalItemHandler(side);
    }

    @Override
    public boolean canConnectStorages() {
        return !this.packed && super.canConnectStorages();
    }

    @Override
    public boolean canBeConnected() {
        return !this.packed && super.canBeConnected();
    }

    public boolean canBeLinked() {
        return !this.packed;
    }

    @Override
    protected boolean canRefreshUpgrades() {
        return super.canRefreshUpgrades() && !this.packed;
    }
}

