/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBlockStateModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelUnbakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public record BarrelItemModel(BarrelBlockStateModelBase model, @Nullable BarrelBlockStateModelBase flatTopModel, List<ItemTintSource> tints, Supplier<Vector3fc[]> extents) implements ItemModel
{
    private static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final ItemTransforms ITEM_TRANSFORMS = BarrelItemModel.createItemTransforms();

    public BarrelItemModel(BarrelBlockStateModelBase model, @Nullable BarrelBlockStateModelBase flatTopModel, List<ItemTintSource> tints) {
        this(model, flatTopModel, tints, (Supplier<Vector3fc[]>)Suppliers.memoize(() -> BlockModelWrapper.computeExtents((List)model.getTierQuads().getAll())));
    }

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(new ItemTransform((Vector3fc)new Vector3f(75.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.15625f, 0.0f), (Vector3fc)new Vector3f(0.375f, 0.375f, 0.375f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(75.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.15625f, 0.0f), (Vector3fc)new Vector3f(0.375f, 0.375f, 0.375f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.890625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.625f, 0.625f, 0.625f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.1875f, 0.0f), (Vector3fc)new Vector3f(0.25f, 0.25f, 0.25f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), ImmutableMap.of());
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext itemDisplayContext, @Nullable ClientLevel clientLevel, @Nullable ItemOwner itemOwner, int i) {
        state.appendModelIdentityElement((Object)this);
        boolean flatTop = BarrelBlockItem.isFlatTop((DataComponentHolder)stack);
        BarrelBlockStateModelBase updatedModel = flatTop && this.flatTopModel != null ? this.flatTopModel : this.model;
        updatedModel.setFlatTop(flatTop);
        state.appendModelIdentityElement((Object)flatTop);
        boolean hasMainColor = StorageBlockItem.getMainColorFromComponentHolder((DataComponentGetter)stack).isPresent();
        updatedModel.setHasMainColor(hasMainColor);
        state.appendModelIdentityElement((Object)hasMainColor);
        boolean hasAccentColor = StorageBlockItem.getAccentColorFromComponentHolder((DataComponentGetter)stack).isPresent();
        updatedModel.setHasAccentColor(hasAccentColor);
        state.appendModelIdentityElement((Object)hasAccentColor);
        Map<BarrelMaterial, Identifier> materials = BarrelBlockItem.getMaterials((DataComponentHolder)stack);
        updatedModel.setBarrelMaterials(materials);
        state.appendModelIdentityElement(materials);
        String woodName = WoodStorageBlockItem.getWoodType((DataComponentHolder)stack).map(WoodType::name).orElse((String)(hasMainColor && hasAccentColor && materials.isEmpty() ? null : WoodType.ACACIA.name()));
        updatedModel.setWoodName(woodName);
        if (woodName != null) {
            state.appendModelIdentityElement((Object)woodName);
        }
        boolean packed = WoodStorageBlockItem.isPacked(stack);
        updatedModel.setPacked(packed);
        state.appendModelIdentityElement((Object)packed);
        boolean showsTier = StorageBlockItem.showsTier(stack);
        updatedModel.setShowsTier(showsTier);
        state.appendModelIdentityElement((Object)showsTier);
        updatedModel.setBarrelItem(stack.getItem());
        state.appendModelIdentityElement((Object)stack.getItem());
        ItemStackRenderState.LayerRenderState layerState = state.newLayer();
        int[] tintArray = new int[this.tints.size()];
        for (int j = 0; j < tintArray.length; ++j) {
            tintArray[j] = this.tints.get(j).calculate(stack, clientLevel, itemOwner == null ? null : itemOwner.asLivingEntity());
            state.appendModelIdentityElement((Object)tintArray[j]);
        }
        int[] aint = layerState.prepareTintLayers(tintArray.length);
        System.arraycopy(tintArray, 0, aint, 0, tintArray.length);
        layerState.setExtents(this.extents);
        layerState.setUsesBlockLight(true);
        layerState.setRenderType(Sheets.translucentBlockItemSheet());
        layerState.setParticleIcon(updatedModel.particleIcon());
        layerState.setTransform(ITEM_TRANSFORMS.getTransform(itemDisplayContext));
        layerState.prepareQuadList().addAll(updatedModel.getQuads(clientLevel != null ? clientLevel.random : Minecraft.getInstance().level.random));
    }

    public record Unbaked(Identifier model, @Nullable Identifier flatTopModel, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)Identifier.CODEC.optionalFieldOf("flat_top_model").forGetter(unbaked -> Optional.ofNullable(unbaked.flatTopModel())), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)instance, (model, flatTopModel, tints) -> new Unbaked((Identifier)model, flatTopModel.orElse(null), (List<ItemTintSource>)tints)));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ResolvedModel flatTopResolved;
            UnbakedModel unbakedModel;
            ResolvedModel resolved = context.blockModelBaker().getModel(this.model);
            UnbakedModel unbakedModel2 = resolved.wrapped();
            if (!(unbakedModel2 instanceof BarrelUnbakedModelBase)) {
                throw new IllegalStateException("Expected BarrelUnbakedModelBase for " + String.valueOf(this.model) + ", got " + resolved.wrapped().getClass().getName());
            }
            BarrelUnbakedModelBase barrelUnbakedModel = (BarrelUnbakedModelBase)unbakedModel2;
            BarrelBlockStateModelBase barrelModel = barrelUnbakedModel.bakeBlockStateModel(context.blockModelBaker(), resolved, (ModelState)BlockModelRotation.IDENTITY);
            BarrelBlockStateModelBase barrelFlatTopModel = null;
            if (this.flatTopModel != null && (unbakedModel = (flatTopResolved = context.blockModelBaker().getModel(this.flatTopModel)).wrapped()) instanceof BarrelUnbakedModelBase) {
                BarrelUnbakedModelBase flatTopUnbakedModel = (BarrelUnbakedModelBase)unbakedModel;
                barrelFlatTopModel = flatTopUnbakedModel.bakeBlockStateModel(context.blockModelBaker(), flatTopResolved, (ModelState)BlockModelRotation.IDENTITY);
            }
            return new BarrelItemModel(barrelModel, barrelFlatTopModel, this.tints);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.model);
            if (this.flatTopModel != null) {
                resolver.markDependency(this.flatTopModel);
            }
        }
    }
}

