/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.OutputTarget;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class ControllerRenderer
implements BlockEntityRenderer<ControllerBlockEntity, ControllerRenderState> {
    public static final RenderPipeline NO_DEPTH_LINES_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.LINES_SNIPPET}).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).withLocation(SophisticatedStorage.getIdentifier("pipeline/controller_lines")).build();
    private static final RenderType LINES = RenderType.create((String)"storage_lines", (RenderSetup)RenderSetup.builder((RenderPipeline)NO_DEPTH_LINES_PIPELINE).bufferSize(1536).setLayeringTransform(LayeringTransform.VIEW_OFFSET_Z_LAYERING).setOutputTarget(OutputTarget.ITEM_ENTITY_TARGET).createRenderSetup());

    private void submitConnectedStorageBlocksInfo(SubmitNodeCollector submitNodeCollector, Direction playerLookDirection, PoseStack poseStack, List<BlockPos> storagePositions, List<Integer> storageSlots, BlockPos controllerPos) {
        double zScale = 0.001;
        float scale = 0.015f;
        int storageOrder = 1;
        for (BlockPos position : storagePositions) {
            double translateX = (double)position.getX() + 0.5 - (double)controllerPos.getX() + 0.501 * (double)playerLookDirection.getUnitVec3i().getX();
            double translateY = (double)position.getY() + 0.5 - (double)controllerPos.getY() + 0.501 * (double)playerLookDirection.getUnitVec3i().getY();
            double translateZ = (double)position.getZ() + 0.5 - (double)controllerPos.getZ() + 0.501 * (double)playerLookDirection.getUnitVec3i().getZ();
            poseStack.pushPose();
            poseStack.translate(translateX, translateY, translateZ);
            Quaternionf rotation = playerLookDirection.getRotation();
            rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)rotation);
            poseStack.translate(-0.45f, 0.45f, 0.0f);
            poseStack.scale(scale, -scale, (float)zScale);
            submitNodeCollector.submitText(poseStack, 0.0f, 0.0f, Component.literal((String)("Order: " + storageOrder)).getVisualOrderText(), false, Font.DisplayMode.NORMAL, 0xF000F0, DyeColor.WHITE.getTextColor(), 0, 0);
            poseStack.translate(0.0f, 10.0f, 0.0f);
            submitNodeCollector.submitText(poseStack, 0.0f, 0.0f, Component.literal((String)("Slots: " + String.valueOf(storageSlots.get(storageOrder - 1)))).getVisualOrderText(), false, Font.DisplayMode.NORMAL, 0xF000F0, DyeColor.WHITE.getTextColor(), 0, 0);
            poseStack.popPose();
            ++storageOrder;
        }
    }

    private void submitLinkedBlocks(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, BlockPos controllerPos, List<VoxelOutliner.Edge> linkedBlockEdges, List<ControllerRenderState.LinkedBlockInfo> linkedBlocks) {
        linkedBlocks.forEach(linkedBlockInfo -> this.submitLineBetweenBlocks(submitNodeCollector, controllerPos, linkedBlockInfo.pos, linkedBlockInfo.center, poseStack, DyeColor.LIME.getTextColor()));
        BlockHighlightRenderHelper.submitThickEdges((SubmitNodeCollector)submitNodeCollector, (PoseStack)poseStack, (int)DyeColor.LIME.getTextColor(), linkedBlockEdges, (BlockPos)controllerPos);
    }

    private void submitStorageBlocksOutline(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, List<VoxelOutliner.Edge> storageBlockEdges, BlockPos controllerPos) {
        BlockHighlightRenderHelper.submitThickEdges((SubmitNodeCollector)submitNodeCollector, (PoseStack)poseStack, (int)6931771, storageBlockEdges, (BlockPos)controllerPos);
    }

    private void submitLineBetweenBlocks(SubmitNodeCollector submitNodeCollector, BlockPos initialPos, BlockPos pos, Vec3 center, PoseStack poseStack, int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float normalX = (float)((double)(pos.getX() - initialPos.getX()) + (0.5 - center.x()));
        float normalY = (float)((double)(pos.getY() - initialPos.getY()) + (0.5 - center.y()));
        float normalZ = (float)((double)(pos.getZ() - initialPos.getZ()) + (0.5 - center.z()));
        submitNodeCollector.submitCustomGeometry(poseStack, LINES, (pose, buffer) -> {
            buffer.addVertex(pose, 0.5f, 0.5f, 0.5f).setColor(red, green, blue, 255).setNormal(pose, normalX, normalY, normalZ).setLineWidth(2.0f);
            buffer.addVertex(pose, (float)((double)(pos.getX() - initialPos.getX()) + center.x()), (float)((double)(pos.getY() - initialPos.getY()) + center.y()), (float)((double)(pos.getZ() - initialPos.getZ()) + center.z())).setColor(red, green, blue, 255).setNormal(pose, normalX, normalY, normalZ).setLineWidth(2.0f);
        });
    }

    private void submitControllerOutline(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, List<VoxelOutliner.Edge> controllerEdges, BlockPos controllerPos) {
        BlockHighlightRenderHelper.submitThickEdges((SubmitNodeCollector)submitNodeCollector, (PoseStack)poseStack, (int)3062783, controllerEdges, (BlockPos)controllerPos);
    }

    public ControllerRenderState createRenderState() {
        return new ControllerRenderState();
    }

    public void extractRenderState(ControllerBlockEntity controller, ControllerRenderState renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)controller, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.DEBUG_TOOL.get())).ifPresent(storageTool -> {
            renderState.storagePositions = controller.getStoragePositions();
            renderState.storageSlots = new ArrayList<Integer>();
            for (int i = 0; i < renderState.storagePositions.size(); ++i) {
                renderState.storageSlots.add(controller.getSlots(i));
            }
        });
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).ifPresent(storageTool -> {
            if (StorageToolItem.getMode(storageTool) != StorageToolItem.Mode.LINK) {
                return;
            }
            renderState.linkedBlockEdges = controller.getLinkedBlockEdges();
            renderState.storageBlockEdges = controller.getStorageBlockEdges();
            renderState.linkedBlocks = controller.getLinkedBlocks().stream().flatMap(pos -> {
                VoxelShape shape = level.getBlockState(pos).getShape((BlockGetter)level, pos);
                if (shape.isEmpty()) {
                    return Stream.empty();
                }
                return Stream.of(new ControllerRenderState.LinkedBlockInfo((BlockPos)pos, shape.bounds().getCenter()));
            }).toList();
            renderState.controllerEdges = StorageToolItem.getControllerLink(storageTool).map(toolControllerPos -> toolControllerPos.equals((Object)controller.getBlockPos())).orElse(false) != false ? controller.getControllerEdges() : Collections.emptyList();
        });
    }

    public void submit(ControllerRenderState controllerRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        BlockPos controllerPos = controllerRenderState.blockPos;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.submitConnectedStorageBlocksInfo(submitNodeCollector, Direction.orderedByNearest((Entity)player)[0].getOpposite(), poseStack, controllerRenderState.storagePositions, controllerRenderState.storageSlots, controllerPos);
        this.submitControllerOutline(submitNodeCollector, poseStack, controllerRenderState.controllerEdges, controllerPos);
        this.submitLinkedBlocks(submitNodeCollector, poseStack, controllerPos, controllerRenderState.linkedBlockEdges, controllerRenderState.linkedBlocks);
        this.submitStorageBlocksOutline(submitNodeCollector, poseStack, controllerRenderState.storageBlockEdges, controllerPos);
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(ControllerBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate((double)Config.SERVER.controllerRange.getAsInt());
    }

    public static class ControllerRenderState
    extends BlockEntityRenderState {
        public List<BlockPos> storagePositions = Collections.emptyList();
        public List<Integer> storageSlots = Collections.emptyList();
        public List<VoxelOutliner.Edge> linkedBlockEdges = Collections.emptyList();
        public List<VoxelOutliner.Edge> storageBlockEdges = Collections.emptyList();
        public List<LinkedBlockInfo> linkedBlocks = Collections.emptyList();
        public List<VoxelOutliner.Edge> controllerEdges = Collections.emptyList();

        public record LinkedBlockInfo(BlockPos pos, Vec3 center) {
        }
    }
}

