/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRendererBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.jspecify.annotations.Nullable;

public class LimitedBarrelRenderer
extends BarrelRendererBase<LimitedBarrelBlockEntity, LimitedBarrelRenderState> {
    public static final Material FILL_INDICATORS_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, SophisticatedStorage.getIdentifier("block/fill_indicators"));
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.010416667f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.020833334f;
    public static final Style INFINITE_COUNT_DISPLAY_STYLE = Style.EMPTY.withFont((FontDescription)new FontDescription.Resource(Minecraft.UNIFORM_FONT));
    private static final Style COUNT_DISPLAY_STYLE = INFINITE_COUNT_DISPLAY_STYLE.withBold(Boolean.valueOf(true));
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.ZERO);
    private final MaterialSet materialSet;

    public LimitedBarrelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.materialSet = context.materials();
    }

    private void submitFrontFace(SubmitNodeCollector submitNodeCollector, LimitedBarrelRenderState renderState, PoseStack poseStack) {
        if (!renderState.displayItems.isEmpty() || this.holdsItemThatShowsUpgrades() || renderState.showsUpgrades || renderState.showsFillLevels || this.holdsItemThatShowsFillLevels()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.horizontalFacing));
            if (renderState.verticalFacing != VerticalFacing.NO) {
                poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.verticalFacing.getDirection()));
            }
            poseStack.translate(-0.5, -0.5, -(0.5 - (double)(renderState.flatTop ? 0.0f : 0.0625f)));
            if (!renderState.displayItems.isEmpty()) {
                this.submitDisplayItems(submitNodeCollector, renderState, poseStack);
            }
            boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
            if (renderState.showsUpgrades || holdsItemThatShowsUpgrades) {
                this.submitUpgrades(submitNodeCollector, renderState, poseStack, holdsItemThatShowsUpgrades);
            }
            if (renderState.showsFillLevels || this.holdsItemThatShowsFillLevels()) {
                this.submitFillLevels(submitNodeCollector, renderState, poseStack);
            }
            poseStack.popPose();
        }
    }

    private void submitUpgrades(SubmitNodeCollector submitNodeCollector, LimitedBarrelRenderState renderState, PoseStack poseStack, boolean holdsItemThatShowsUpgrades) {
        if (renderState.flatTop) {
            this.flatDisplayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, renderState.showsDisabledUpgradeDisplay);
        } else {
            this.displayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, renderState.showsDisabledUpgradeDisplay);
        }
    }

    private void submitFillLevels(SubmitNodeCollector submitNodeCollector, LimitedBarrelRenderState renderState, PoseStack poseStack) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, -0.001);
        int slots = renderState.fillLevels.size();
        boolean translucentRender = !renderState.showsFillLevels && this.holdsToolInToggleFillLevelDisplay();
        switch (slots) {
            case 1: {
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(0).floatValue(), 0.0625f, 0.0625f, true, translucentRender);
                break;
            }
            case 2: {
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(1).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 3: {
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(1).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(2).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 4: {
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(0).floatValue(), 0.875f, 0.5625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(1).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(2).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.submitFillLevel(submitNodeCollector, poseStack, renderState.lightCoords, renderState.fillLevels.get(3).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
            }
        }
        poseStack.popPose();
    }

    private void submitDisplayItems(SubmitNodeCollector submitNodeCollector, LimitedBarrelRenderState renderState, PoseStack poseStack) {
        if (renderState.flatTop) {
            this.flatDisplayItemRenderer.submitDisplayItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY);
        } else {
            this.displayItemRenderer.submitDisplayItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY);
        }
    }

    private void submitItemCounts(SubmitNodeCollector submitNodeCollector, LimitedBarrelRenderState renderState, PoseStack poseStack) {
        if (!renderState.showsCounts) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.horizontalFacing.getOpposite()));
        if (renderState.verticalFacing != VerticalFacing.NO) {
            poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.verticalFacing.getDirection().getOpposite()));
        }
        poseStack.translate(0.5, -0.5, 0.5);
        float countDisplayYOffset = -(renderState.slotCounts.size() == 1 ? 0.25f : 0.11f);
        for (int displayItemIndex = 0; displayItemIndex < renderState.slotCounts.size(); ++displayItemIndex) {
            float scale;
            int count = renderState.slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.pushPose();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, renderState.slotCounts.size());
            double xTranslation = -frontOffset.x();
            boolean isInfinite = renderState.infiniteSlots.contains(displayItemIndex);
            float yTranslation = frontOffset.y() + (isInfinite ? countDisplayYOffset / 1.8f : countDisplayYOffset);
            double zTranslation = 0.001 - (renderState.flatTop ? 0.0 : 0.046875);
            poseStack.translate(xTranslation, (double)yTranslation, zTranslation);
            float f = scale = renderState.slotCounts.size() == 1 ? 0.020833334f : 0.010416667f;
            if (isInfinite) {
                scale *= 2.0f;
            }
            poseStack.scale(scale, -scale, scale);
            MutableComponent countString = isInfinite ? Component.literal((String)"\u221e").withStyle(INFINITE_COUNT_DISPLAY_STYLE) : Component.literal((String)CountAbbreviator.abbreviate((int)count, (int)(renderState.slotCounts.size() == 1 ? 6 : 5))).withStyle(COUNT_DISPLAY_STYLE);
            Font font = Minecraft.getInstance().font;
            float countDisplayXOffset = -font.getSplitter().stringWidth((FormattedText)countString) / 2.0f;
            poseStack.translate(countDisplayXOffset, 0.0f, 0.0f);
            submitNodeCollector.submitText(poseStack, 0.0f, 0.0f, countString.getVisualOrderText(), false, Font.DisplayMode.NORMAL, renderState.lightCoords, renderState.slotColors.get(displayItemIndex).intValue(), 0, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void submitFillLevel(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, float fillLevel, float x, float y, boolean large, boolean translucentRender) {
        poseStack.pushPose();
        poseStack.translate(x + 0.0125f, y + 0.0125f, 0.0f);
        int barHeight = large ? 14 : 6;
        poseStack.scale(0.0375f, fillLevel * 1.0f / 16.0f / 5.0f * (float)(barHeight * 5 - 2), 1.0f);
        poseStack.pushPose();
        RenderType renderType = translucentRender ? FILL_INDICATORS_TEXTURE.renderType(RenderTypes::entityTranslucent) : FILL_INDICATORS_TEXTURE.renderType(RenderTypes::entitySmoothCutout);
        TextureAtlasSprite sprite = this.materialSet.get(FILL_INDICATORS_TEXTURE);
        submitNodeCollector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
            Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
            pose.normal().transform(normal);
            float minU = large ? 0.0f : 0.0234375f;
            float maxV = large ? 0.53125f : 0.21875f;
            RenderHelper.renderQuad(vertexConsumer, pose.pose(), normal, OverlayTexture.NO_OVERLAY, packedLight, translucentRender ? 0.5f : 1.0f, minU, (1.0f - fillLevel) * maxV, minU + 0.0234375f, maxV, sprite);
        });
        poseStack.popPose();
        poseStack.popPose();
    }

    public LimitedBarrelRenderState createRenderState() {
        return new LimitedBarrelRenderState();
    }

    @Override
    public void extractRenderState(LimitedBarrelBlockEntity blockEntity, LimitedBarrelRenderState renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        if (renderState.packed) {
            return;
        }
        renderState.showsCounts = blockEntity.shouldShowCounts();
        renderState.showsFillLevels = blockEntity.shouldShowFillLevels();
        BlockState blockState = blockEntity.getBlockState();
        renderState.horizontalFacing = (Direction)blockState.getValue(LimitedBarrelBlock.HORIZONTAL_FACING);
        renderState.verticalFacing = (VerticalFacing)((Object)blockState.getValue(LimitedBarrelBlock.VERTICAL_FACING));
        if (blockEntity.getLevel() != null && blockEntity.shouldUseLightInFrontForFrontRender()) {
            renderState.lightCoords = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().relative(renderState.verticalFacing != VerticalFacing.NO ? renderState.verticalFacing.getDirection() : renderState.horizontalFacing));
        }
        RenderData.DisplayData displayData = blockEntity.getStorageWrapper().getRenderDataHandler().getDisplayData();
        renderState.slotCounts = displayData.slotCounts();
        renderState.infiniteSlots = new HashSet<Integer>(displayData.infiniteSlots());
        renderState.slotColors = IntStream.range(0, renderState.slotCounts.size()).map(blockEntity::getSlotColor).boxed().toList();
        renderState.fillLevels = blockEntity.getSlotFillLevels();
    }

    public void submit(LimitedBarrelRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.packed || renderState.displayItems.isEmpty() && !renderState.showsCounts && !this.holdsItemThatShowsUpgrades() && !renderState.showsUpgrades) {
            return;
        }
        this.submitItemCounts(submitNodeCollector, renderState, poseStack);
        this.submitFrontFace(submitNodeCollector, renderState, poseStack);
        this.submitHiddenTier(submitNodeCollector, renderState, poseStack);
        this.submitHiddenLock(submitNodeCollector, renderState, poseStack);
    }

    public static class LimitedBarrelRenderState
    extends BarrelRendererBase.BarrelRenderStateBase {
        public boolean showsCounts;
        public boolean showsFillLevels;
        public Direction horizontalFacing;
        public VerticalFacing verticalFacing;
        public List<Integer> slotCounts;
        public Set<Integer> infiniteSlots;
        public List<Integer> slotColors;
        public List<Float> fillLevels;
    }
}

