/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderState;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class ShulkerBoxRenderer
extends StorageRenderer<ShulkerBoxBlockEntity, ShulkerBoxRenderState> {
    private static final String ENTITY_SHULKER_BOX_FOLDER = "entity/shulker_box/";
    public static final Material BASE_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/base_tier"));
    public static final Material COPPER_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/copper_tier"));
    public static final Material IRON_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/iron_tier"));
    public static final Material GOLD_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/gold_tier"));
    public static final Material DIAMOND_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/diamond_tier"));
    public static final Material NETHERITE_TIER_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/netherite_tier"));
    public static final Material TINTABLE_MAIN_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/tintable_main"));
    public static final Material TINTABLE_ACCENT_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/tintable_accent"));
    public static final Material NO_TINT_MATERIAL = new Material(Sheets.SHULKER_SHEET, SophisticatedStorage.getIdentifier("entity/shulker_box/no_tint"));
    private final ShulkerBoxModel model;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0075));
    private final MaterialSet materialSet;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new ShulkerBoxModel(context.bakeLayer(ModelLayers.SHULKER));
        this.materialSet = context.materials();
    }

    public ModelPart rootModelPart() {
        return this.model.root();
    }

    private Material getTierMaterial(Block block) {
        if (block == ModBlocks.COPPER_SHULKER_BOX.get()) {
            return COPPER_TIER_MATERIAL;
        }
        if (block == ModBlocks.IRON_SHULKER_BOX.get()) {
            return IRON_TIER_MATERIAL;
        }
        if (block == ModBlocks.GOLD_SHULKER_BOX.get()) {
            return GOLD_TIER_MATERIAL;
        }
        if (block == ModBlocks.DIAMOND_SHULKER_BOX.get()) {
            return DIAMOND_TIER_MATERIAL;
        }
        if (block == ModBlocks.NETHERITE_SHULKER_BOX.get()) {
            return NETHERITE_TIER_MATERIAL;
        }
        return BASE_TIER_MATERIAL;
    }

    public ShulkerBoxRenderState createRenderState() {
        return new ShulkerBoxRenderState();
    }

    @Override
    public void extractRenderState(ShulkerBoxBlockEntity blockEntity, ShulkerBoxRenderState renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        BlockState blockState = blockEntity.getBlockState();
        renderState.facing = !blockEntity.getBlockPos().equals((Object)BlockPos.ZERO) || blockEntity.hasLevel() && blockEntity.getLevel().getBlockState(BlockPos.ZERO).getBlock() instanceof ShulkerBoxBlock ? (Direction)blockState.getValue(ShulkerBoxBlock.FACING) : Direction.UP;
        renderState.lidProgress = blockEntity.getProgress(partialTick);
        renderState.mainColor = blockEntity.getStorageWrapper().getMainColor();
        renderState.accentColor = blockEntity.getStorageWrapper().getAccentColor();
    }

    public void submit(ShulkerBoxRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(0.9995f, 0.9995f, 0.9995f);
        poseStack.mulPose((Quaternionfc)renderState.facing.getRotation());
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.translate(0.0, -1.0, 0.0);
        ModelPart lidPart = this.model.lid;
        lidPart.setPos(0.0f, 24.0f - renderState.lidProgress * 0.5f * 16.0f, 0.0f);
        lidPart.yRot = 270.0f * renderState.lidProgress * ((float)Math.PI / 180);
        if (renderState.mainColor == -1 || renderState.accentColor == -1) {
            RenderType renderType = NO_TINT_MATERIAL.renderType(RenderTypes::entityCutoutNoCull);
            submitNodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materialSet.get(NO_TINT_MATERIAL), 0, renderState.breakProgress);
        }
        if (renderState.mainColor != -1) {
            int color = 0xFF000000 | renderState.mainColor;
            submitNodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, TINTABLE_MAIN_MATERIAL.renderType(RenderTypes::entityCutoutNoCull), renderState.lightCoords, OverlayTexture.NO_OVERLAY, color, this.materialSet.get(TINTABLE_MAIN_MATERIAL), 0, renderState.breakProgress);
        }
        if (renderState.accentColor != -1) {
            int accentColor = 0xFF000000 | renderState.accentColor;
            submitNodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, TINTABLE_ACCENT_MATERIAL.renderType(RenderTypes::entityCutoutNoCull), renderState.lightCoords, OverlayTexture.NO_OVERLAY, accentColor, this.materialSet.get(TINTABLE_ACCENT_MATERIAL), 0, renderState.breakProgress);
        }
        if (renderState.showsTier) {
            tierMaterial = this.getTierMaterial(renderState.blockState.getBlock());
            RenderType renderType = RenderTypes.entityCutoutNoCull((Identifier)tierMaterial.atlasLocation());
            submitNodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materialSet.get(tierMaterial), 0, renderState.breakProgress);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            tierMaterial = this.getTierMaterial(renderState.blockState.getBlock());
            RenderType renderType = RenderTypes.entityTranslucent((Identifier)tierMaterial.atlasLocation());
            poseStack.pushPose();
            poseStack.translate(0.0, -0.01, 0.0);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            int color = Integer.MAX_VALUE;
            submitNodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, color, this.materialSet.get(tierMaterial), 0, renderState.breakProgress);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.facing));
        float zOffset = 0.0f;
        if (renderState.lidProgress > 0.0f) {
            zOffset = renderState.lidProgress * 0.5f;
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(270.0f * renderState.lidProgress));
        }
        poseStack.translate(-0.5, -0.5, -0.5 - (double)zOffset);
        if (renderState.showsUpgrades || this.holdsItemThatShowsUpgrades()) {
            this.displayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, renderState.showsDisabledUpgradeDisplay);
        }
        if (!renderState.displayItems.isEmpty()) {
            this.displayItemRenderer.submitDisplayItem(submitNodeCollector, poseStack, renderState.lightCoords, OverlayTexture.NO_OVERLAY, (StorageRenderState.DisplayItemInfo)renderState.displayItems.getFirst());
        }
        LockRenderer.submitLock(submitNodeCollector, renderState, poseStack, 0.9375f, this::holdsToolInToggleLockOrLockDisplay, this.materialSet);
        poseStack.popPose();
    }

    static class ShulkerBoxModel
    extends Model<ShulkerBoxRenderState> {
        private final ModelPart lid;

        public ShulkerBoxModel(ModelPart root) {
            super(root, RenderTypes::entityCutoutNoCull);
            this.lid = root.getChild("lid");
        }

        public void setupAnim(ShulkerBoxRenderState renderState) {
            super.setupAnim((Object)renderState);
            this.lid.setPos(0.0f, 24.0f - renderState.lidProgress * 0.5f * 16.0f, 0.0f);
            this.lid.yRot = 270.0f * renderState.lidProgress * ((float)Math.PI / 180);
        }
    }

    public static class ShulkerBoxRenderState
    extends StorageRenderState {
        Direction facing;
        float lidProgress;
        int mainColor;
        int accentColor;
    }
}

