/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.crafting.CustomShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jspecify.annotations.Nullable;

public class ShulkerBoxFromVanillaShapelessRecipe
extends CustomShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    private final ShapelessRecipe compose;

    public ShulkerBoxFromVanillaShapelessRecipe(ShapelessRecipe compose) {
        super("", CraftingBookCategory.MISC, compose.result, compose.ingredients);
        this.compose = compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.getVanillaShulkerBox(input).map(storage -> !(storage.getItem() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedStorage = super.assemble(input, registries);
        this.getVanillaShulkerBox(input).ifPresent(vanillaShulkerBox -> {
            @Nullable ResourceHandler itemCap = (ResourceHandler)vanillaShulkerBox.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)vanillaShulkerBox));
            if (itemCap != null) {
                StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, upgradedStorage);
                try (Transaction tx = Transaction.openRoot();){
                    InventoryHelper.iterate((ResourceHandler)itemCap, (slot, resource, amount) -> {
                        if (!resource.isEmpty()) {
                            wrapper.getInventoryHandler().insert(resource, amount.intValue(), (TransactionContext)tx);
                        }
                    });
                    tx.commit();
                }
            }
        });
        return upgradedStorage;
    }

    private Optional<ItemStack> getVanillaShulkerBox(CraftingInput input) {
        for (int slot = 0; slot < input.size(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = input.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<ShulkerBoxFromVanillaShapelessRecipe> getSerializer() {
        return ModBlocks.SHULKER_BOX_FROM_VANILLA_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, ShulkerBoxFromVanillaShapelessRecipe> {
        public Serializer() {
            super(ShulkerBoxFromVanillaShapelessRecipe::new, RecipeSerializer.SHAPELESS_RECIPE);
        }
    }
}

