/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import com.mojang.math.Quadrant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.client.model.generators.blockstate.CustomBlockStateModelBuilder;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.p3pp3rf1y.sophisticatedcore.data.SophisticatedModelProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.init.StorageTintSources;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelItemModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestBlockStateModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxBlockStateModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.data.BarrelBlockStateModelBuilder;
import net.p3pp3rf1y.sophisticatedstorage.data.UnitBlockStateModelBuilder;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;

public class StorageModelProvider
extends SophisticatedModelProvider {
    private static final Identifier BASE_CHEST_PARTICLE = Identifier.fromNamespaceAndPath((String)"sophisticatedstorage", (String)"block/break/acacia_chest");
    private static final Identifier BASE_SHULKER_BOX_PARTICLE = Identifier.fromNamespaceAndPath((String)"sophisticatedstorage", (String)"block/break/shulker_box");
    private static final PropertyDispatch<VariantMutator> VERTICAL_FACING = PropertyDispatch.modify(LimitedBarrelBlock.VERTICAL_FACING).select((Comparable)((Object)VerticalFacing.NO), (Object)VariantMutator.X_ROT.withValue((Object)Quadrant.R90)).select((Comparable)((Object)VerticalFacing.DOWN), (Object)VariantMutator.X_ROT.withValue((Object)Quadrant.R180)).select((Comparable)((Object)VerticalFacing.UP), (Object)BlockModelGenerators.NOP);

    public StorageModelProvider(PackOutput output) {
        super(output, "sophisticatedstorage");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.generateBlockModels(blockModels);
        this.generateItemModels(itemModels);
    }

    private void generateBlockModels(BlockModelGenerators blockModels) {
        ArrayList barrelItems = new ArrayList();
        this.addItemClasses(barrelItems, List.of(BarrelBlockItem.class));
        barrelItems.forEach(item -> this.generateBarrel(blockModels, (Item)item));
        this.generateBlockWithCustomBlockStateModel(blockModels, "chest", (Block)ModBlocks.CHEST.get(), ModelTemplates.CHEST_INVENTORY, BASE_CHEST_PARTICLE, ChestBlock.class, new ChestItemRenderer.Unbaked(), ChestBlockStateModel.Unbaked::new);
        this.generateBlockWithCustomBlockStateModel(blockModels, "shulker_box", (Block)ModBlocks.SHULKER_BOX.get(), ModelTemplates.SHULKER_BOX_INVENTORY, BASE_SHULKER_BOX_PARTICLE, ShulkerBoxBlock.class, new ShulkerBoxItemRenderer.Unbaked(), ShulkerBoxBlockStateModel.Unbaked::new);
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.CONTROLLER.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_IO.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_INPUT.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_OUTPUT.get());
        ModBlocks.STORAGE_CONNECTOR_BLOCKS.values().stream().map(Supplier::get).forEach(arg_0 -> ((BlockModelGenerators)blockModels).createTrivialCube(arg_0));
        StorageModelProvider.generateCustomModelBlock(blockModels, (Block)ModBlocks.DECORATION_TABLE.get(), (PropertyDispatch<VariantMutator>)BlockModelGenerators.ROTATION_HORIZONTAL_FACING);
        StorageModelProvider.generateCustomModelBlock(blockModels, (Block)ModBlocks.STORAGE_LINK.get(), (PropertyDispatch<VariantMutator>)BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING);
    }

    private void generateBlockWithCustomBlockStateModel(BlockModelGenerators blockModels, String loaderName, Block baseBlock, ModelTemplate itemModelTemplate, Identifier baseParticle, Class<? extends Block> blockClass, SpecialModelRenderer.Unbaked unbakedSpecialRenderer, Supplier<CustomUnbakedBlockStateModel> unbakedBlockStateModelSupplier) {
        TexturedModel.Provider provider = TexturedModel.createDefault(b -> new TextureMapping(), (ModelTemplate)ExtendedModelTemplateBuilder.builder().customLoader(() -> this.createSimpleCustomLoaderBuilder(loaderName), loader -> {}).build());
        Identifier itemModel = itemModelTemplate.create(baseBlock.asItem(), TextureMapping.particle((Identifier)baseParticle), blockModels.modelOutput);
        BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).identifier().getNamespace().equals(this.modId) && blockClass.isAssignableFrom(((Block)entry.getValue()).getClass())).forEach(entry -> {
            Block block = (Block)entry.getValue();
            this.generateForCustomBlockStateModelBlock(blockModels, block, itemModel, unbakedBlockStateModelSupplier, unbakedSpecialRenderer);
        });
    }

    private CustomLoaderBuilder createSimpleCustomLoaderBuilder(final String name) {
        return new CustomLoaderBuilder(Identifier.fromNamespaceAndPath((String)this.modId, (String)name), false){

            protected CustomLoaderBuilder copyInternal() {
                return StorageModelProvider.this.createSimpleCustomLoaderBuilder(name);
            }
        };
    }

    private void generateForCustomBlockStateModelBlock(BlockModelGenerators blockModels, Block block, Identifier itemModel, final Supplier<CustomUnbakedBlockStateModel> unbakedBlockStateModelSupplier, SpecialModelRenderer.Unbaked unbakedSpecialRenderer) {
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)MultiVariant.of((CustomBlockStateModelBuilder)new UnitBlockStateModelBuilder(this){

            public CustomUnbakedBlockStateModel toUnbaked() {
                return (CustomUnbakedBlockStateModel)unbakedBlockStateModelSupplier.get();
            }
        })));
        Item item = block.asItem();
        ItemModel.Unbaked unbakedItemModel = ItemModelUtils.specialModel((Identifier)itemModel, (SpecialModelRenderer.Unbaked)unbakedSpecialRenderer);
        blockModels.itemModelOutput.accept(item, unbakedItemModel);
    }

    private void generateBarrel(BlockModelGenerators blockModels, Item item) {
        if (item instanceof BarrelBlockItem) {
            BarrelBlockItem barrelBlockItem = (BarrelBlockItem)item;
            Block block = barrelBlockItem.getBlock();
            Identifier blockModelId = ModelLocationUtils.getModelLocation((Block)block);
            Identifier flatTopBlockModelId = StorageModelProvider.getFlatTopModelLocation(block);
            MultiVariantGenerator multiVariantGenerator = MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)BarrelBlock.FLAT_TOP).select((Comparable)Boolean.valueOf(false), (Object)MultiVariant.of((CustomBlockStateModelBuilder)new BarrelBlockStateModelBuilder(blockModelId))).select((Comparable)Boolean.valueOf(true), (Object)MultiVariant.of((CustomBlockStateModelBuilder)new BarrelBlockStateModelBuilder(flatTopBlockModelId))));
            multiVariantGenerator = block instanceof LimitedBarrelBlock ? multiVariantGenerator.with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING).with(VERTICAL_FACING) : multiVariantGenerator.with(BlockModelGenerators.ROTATIONS_COLUMN_WITH_FACING);
            blockModels.blockStateOutput.accept(multiVariantGenerator);
            blockModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BarrelItemModel.Unbaked(blockModelId, flatTopBlockModelId, List.of(new StorageTintSources.Main(-1), new StorageTintSources.Accent(-1))));
        }
    }

    private static void generateCustomModelBlock(BlockModelGenerators blockModels, Block block, PropertyDispatch<VariantMutator> facingPropertyDispatch) {
        Identifier blockModelId = ModelLocationUtils.getModelLocation((Block)block);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)blockModelId)).with(facingPropertyDispatch));
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((Identifier)blockModelId));
    }

    private static Identifier getFlatTopModelLocation(Block block) {
        Identifier identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        return identifier.withPrefix("block/flat/");
    }

    private void generateItemModels(ItemModelGenerators itemModels) {
        ArrayList<Item> flatItems = new ArrayList<Item>();
        this.addItemClasses(flatItems, List.of(UpgradeItemBase.class, StorageTierUpgradeItem.class));
        flatItems.add((Item)ModItems.DEBUG_TOOL.get());
        flatItems.add((Item)ModItems.PACKING_TAPE.get());
        flatItems.add((Item)ModItems.SUPER_PACKING_TAPE.get());
        flatItems.add((Item)ModItems.UPGRADE_BASE.get());
        flatItems.add(ModItems.INACCESSIBLE_SLOT.get());
        flatItems.forEach(item -> itemModels.generateFlatItem(item, ModelTemplates.FLAT_ITEM));
        itemModels.generateFlatItem((Item)ModItems.STORAGE_TOOL.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModItems.PAINTBRUSH.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
    }
}

