/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import org.jspecify.annotations.Nullable;

public class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private ItemStack storageStack;

    public StackStorageWrapper(ItemStack storageStack) {
        super(() -> () -> {}, () -> {}, () -> {});
        this.setStorageStack(storageStack);
    }

    public static StackStorageWrapper fromStack(HolderLookup.Provider registries, ItemStack stack) {
        StackStorageWrapper stackStorageWrapper = (StackStorageWrapper)StorageWrapperRepository.getStorageWrapper((ItemStack)stack, StackStorageWrapper.class, StackStorageWrapper::new);
        UUID uuid = (UUID)stack.get(ModCoreDataComponents.STORAGE_UUID);
        if (uuid != null) {
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            CompoundTag storageWrappertag = itemContentsStorage.getOrCreateAddtionalBeData(uuid).getCompoundOrEmpty("storageWrapper");
            ContainerContents contents = itemContentsStorage.getOrCreateContents(uuid);
            Tag contentsTag = (Tag)ContainerContents.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (Object)contents).getOrThrow();
            storageWrappertag.put(CONTENTS_TAG, contentsTag);
            stackStorageWrapper.deserialize(ValueIOHelper.inputFromCompoundTag((HolderLookup.Provider)registries, (CompoundTag)storageWrappertag));
            stackStorageWrapper.setContentsUuid(uuid);
        }
        return stackStorageWrapper;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    public boolean hasContents() {
        return this.contentsUuid != null;
    }

    @Override
    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            this.storageStack.set(ModCoreDataComponents.STORAGE_UUID, (Object)contentsUuid);
            this.onContentsUpdated();
        }
    }

    @Override
    public ContainerContents getContents() {
        if (this.contentsUuid == null) {
            this.contentsUuid = this.getNewUuid();
            this.setContentsUuid(this.contentsUuid);
        }
        return ItemContentsStorage.get().getOrCreateContents(this.contentsUuid);
    }

    @Override
    protected void onUpgradeRefresh() {
    }

    @Override
    public int getDefaultNumberOfInventorySlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    protected void loadSlotNumbers(ValueInput in) {
        this.numberOfInventorySlots = (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)0);
        this.numberOfUpgradeSlots = (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)0);
    }

    @Override
    public int getDefaultNumberOfUpgradeSlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    protected void setStorageStack(ItemStack storageStack) {
        this.storageStack = storageStack;
    }

    @Override
    protected boolean isAllowedInStorage(ItemResource resource) {
        if (!(this.storageStack.getItem() instanceof ShulkerBoxItem)) {
            return false;
        }
        Block block = Block.byItem((Item)resource.getItem());
        return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(resource.getItem());
    }

    public String getStorageType() {
        return "irrelevant";
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Override
    public void setColors(int mainColor, int accentColor) {
        this.storageStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
        this.storageStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
        this.save();
    }

    @Override
    public int getMainColor() {
        return (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.MAIN_COLOR, (Object)-1);
    }

    @Override
    public boolean hasMainColor() {
        return this.storageStack.has(ModCoreDataComponents.MAIN_COLOR);
    }

    @Override
    public int getAccentColor() {
        return (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.ACCENT_COLOR, (Object)-1);
    }

    @Override
    public boolean hasAccentColor() {
        return this.storageStack.has(ModCoreDataComponents.ACCENT_COLOR);
    }
}

