/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;

public record RequestControllerTargetHighlightsPayload(ItemStack stack, List<BlockPos> controllerPositions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestControllerTargetHighlightsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedStorage.getIdentifier("request_controller_target_highlights"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestControllerTargetHighlightsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RequestControllerTargetHighlightsPayload::stack, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), RequestControllerTargetHighlightsPayload::controllerPositions, RequestControllerTargetHighlightsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestControllerTargetHighlightsPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ArrayList stackStorages = new ArrayList();
            ArrayList itemStorages = new ArrayList();
            ArrayList emptyTargetSlotStorages = new ArrayList();
            ItemStackKey stackKey = ItemStackKey.of((ItemStack)payload.stack());
            payload.controllerPositions().forEach(pos -> {
                Level level = player.level();
                WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(controller -> {
                    stackStorages.addAll(controller.getStackStorages(stackKey));
                    itemStorages.addAll(controller.getItemStorages(stackKey));
                    emptyTargetSlotStorages.addAll(controller.getEmptyTargetSlotStorages(stackKey));
                });
            });
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemHighlightsPayload(stackStorages, itemStorages, emptyTargetSlotStorages), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

