/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.keymapping;

import com.mojang.blaze3d.platform.InputConstants;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyConflictContext;
import journeymap.client.event.handlers.keymapping.KeyModifier;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;
import journeymap.client.event.keymapping.NeoForgeKeyHooks;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;

public class NeoForgeUpdateAwareKeyBinding
extends KeyMapping
implements UpdateAwareKeyBinding {
    KeyModifier keyModifier;
    IKeyConflictContext conflictContext;
    InputConstants.Key key;
    final KeyEventHandler handler;

    public NeoForgeUpdateAwareKeyBinding(String description, KeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, KeyMapping.Category category, KeyEventHandler handler) {
        super(description, NeoForgeKeyHooks.getForgeConflictContext(keyConflictContext), NeoForgeKeyHooks.getForgeModifier(keyModifier), inputType, keyCode, category);
        this.keyModifier = keyModifier;
        this.conflictContext = NeoForgeKeyHooks.getForgeConflictContext(keyConflictContext);
        this.handler = handler;
        this.key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
    }

    public void setKey(InputConstants.Key key) {
        super.setKey(key);
        if (this.handler != null) {
            this.handler.sortActionsNeeded = true;
            this.handler.sortActions();
        }
    }

    @Override
    public InputConstants.Key getKeyValue() {
        return super.getKey();
    }

    @Override
    public boolean modifierActive() {
        return this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    @Override
    public boolean isKeyPressed() {
        return this.isDown();
    }

    @Override
    public Component getTranslatedName() {
        return this.getTranslatedKeyMessage();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public KeyMapping getMapping() {
        return this;
    }

    @Override
    public KeyModifier getModifier() {
        return this.keyModifier;
    }

    @Override
    public boolean isActiveAndMatches(InputConstants.Key keyCode) {
        return keyCode != InputConstants.UNKNOWN && keyCode.equals((Object)this.getKey()) && this.getKeyConflictContext().isActive() && super.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public void setKeyModifierAndCode(net.neoforged.neoforge.client.settings.KeyModifier keyModifier, InputConstants.Key keyCode) {
        super.setKeyModifierAndCode(keyModifier, keyCode);
        if (this.handler != null) {
            this.handler.sortActionsNeeded = true;
            this.handler.sortActions();
        }
    }
}

