/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.cartography.color.BiomeColor;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.block.BlockMD;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;

public abstract class ColorPaletteItem
extends Slot {
    private final Font fontRenderer;
    final ColorPaletteScreen screen;
    public int x;
    public int y;
    private int width;
    public final ColorPalette palette;
    private final String name;
    public final String id;
    private final boolean underDefault;
    private final Button buttonEdit;
    private final Button buttonCopy;
    private final Button buttonDelete;
    private int hgap = 4;
    private final ButtonList buttonList;
    private long lastClick = 0L;
    private boolean displayHover = true;

    public ColorPaletteItem(ColorPalette palette, String name, String id, boolean underDefault, Font fontRenderer, ColorPaletteScreen screen) {
        this.palette = palette;
        this.name = name;
        this.id = id;
        this.underDefault = underDefault;
        this.fontRenderer = fontRenderer;
        this.screen = screen;
        this.buttonEdit = new Button(Constants.getString("jm.waypoint.edit"), b -> this.openColorPaletteItemEditor());
        this.buttonList = new ButtonList(this.buttonEdit);
        if (palette.getType() != ColorPalette.Type.Default) {
            String copyLabel = Constants.getString(palette.getType() == ColorPalette.Type.Global ? "jm.colorpalette.copy_to_world" : "jm.colorpalette.copy_to_global");
            this.buttonCopy = new Button(copyLabel, b -> this.copy());
            this.buttonList.add(this.buttonCopy);
            this.buttonDelete = new Button(Constants.getString("jm.common.delete"), b -> this.removeFromPalette());
            this.buttonList.add(this.buttonDelete);
        } else {
            this.buttonCopy = null;
            this.buttonDelete = null;
        }
        this.buttonList.setHeights(screen.rowHeight / 2);
        this.buttonList.fitWidths(fontRenderer);
        this.buttonList.setDefaultStyle(true);
    }

    abstract void copy();

    abstract void removeFromPalette();

    abstract void openColorPaletteItemEditor();

    abstract Collection<Integer> getColors();

    protected void drawLabels(GuiGraphics graphics, Minecraft mc, int x, int y) {
        int height = this.screen.rowHeight - 4;
        if (this.underDefault) {
            int n = height / 2;
            Objects.requireNonNull(this.fontRenderer);
            int yOffset = n - 9 / 2;
            String label = this.palette.getType() == ColorPalette.Type.Global ? "jm.colorpalette.global" : "jm.colorpalette.world";
            graphics.drawString(this.fontRenderer, Constants.getString(label), x + 28, y + yOffset, -1862270977, true);
        } else {
            int n = height / 3;
            Objects.requireNonNull(this.fontRenderer);
            int yOffset = n - 9 / 2;
            graphics.drawString(this.fontRenderer, this.name, x + 20, y + yOffset, -1, true);
            int n2 = height / 3 * 2;
            Objects.requireNonNull(this.fontRenderer);
            yOffset = n2 - 9 / 2;
            graphics.drawString(this.fontRenderer, this.id, x + 20, y + yOffset, -1862270977, true);
        }
    }

    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
        Minecraft mc = this.screen.getMinecraft();
        this.width = this.getContentWidth();
        this.x = super.getContentX();
        this.y = super.getContentY();
        int counter = 0;
        int xPadding = 8;
        double stateWidth = (double)(this.width - xPadding - 4) / (double)this.getColors().size();
        for (int color : this.getColors()) {
            graphics.fill((int)((double)(this.x + xPadding) + stateWidth * (double)counter), this.y, (int)((double)(this.x + xPadding) + stateWidth * (double)(counter + 1)), this.y + this.screen.rowHeight - 4, color | 0xFF000000);
            ++counter;
        }
        if (this.underDefault) {
            int halfRowHeight = this.screen.rowHeight / 2;
            graphics.vLine(this.x - 2, this.y - this.screen.rowHeight, this.y - this.screen.rowHeight + halfRowHeight * 3 - 2, -1);
            graphics.hLine(this.x - 2, this.x - 1 + xPadding, this.y + halfRowHeight - 2, -1);
        } else {
            int color = this.getColors().stream().findFirst().get();
            graphics.fill(this.x, this.y, this.x + xPadding, this.y + this.screen.rowHeight - 4, color | 0xFF000000);
        }
        this.drawLabels(graphics, mc, this.x, this.y);
        boolean drawHovered = hovered && this.displayHover || this.isFocused();
        this.buttonList.setOptions(true, drawHovered, true);
        this.buttonEdit.drawHovered(drawHovered);
        if (this.buttonCopy != null) {
            this.buttonCopy.drawHovered(drawHovered);
        }
        if (this.buttonDelete != null) {
            this.buttonDelete.drawHovered(drawHovered);
        }
        if (drawHovered) {
            int margin = (this.getContentHeight() - this.buttonList.getHeight()) / 2;
            this.buttonList.layoutHorizontal(this.x + this.width - margin - 4, this.y + margin, false, this.hgap).draw(graphics, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        try {
            if (this.buttonEdit.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.buttonCopy != null && this.buttonCopy.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.buttonDelete != null && this.buttonDelete.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (event.button() == 0 && doubleClick) {
                this.openColorPaletteItemEditor();
                return true;
            }
            this.focusEditButton();
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
            throw new RuntimeException("mouseClicked", e);
        }
    }

    public void focusEditButton() {
        this.screen.changeFocus(ComponentPath.path((ContainerEventHandler)this.screen, (ComponentPath)ComponentPath.path((ContainerEventHandler)this.screen.itemScrollPane, (ComponentPath)ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.buttonEdit)))));
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    public SlotMetadata getLastPressed() {
        return null;
    }

    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return this.width;
    }

    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    @Override
    public void displayHover(boolean enabled) {
        this.displayHover = enabled;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.buttonList;
    }

    public static enum SortType implements KeyedEnum
    {
        Id("jm.colorpalette.id"),
        Name("jm.colorpalette.name");

        final String key;

        private SortType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    static class IdComparator
    extends Sort {
        public IdComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(ColorPaletteItem o1, ColorPaletteItem o2) {
            int c = this.descending ? o2.id.compareToIgnoreCase(o1.id) : o1.id.compareToIgnoreCase(o2.id);
            if (c == 0) {
                c = o1.palette.getType().compareTo(o2.palette.getType());
            }
            return c;
        }
    }

    static class NameComparator
    extends Sort {
        public NameComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(ColorPaletteItem o1, ColorPaletteItem o2) {
            int c = this.descending ? o2.name.compareToIgnoreCase(o1.name) : o1.name.compareToIgnoreCase(o2.name);
            if (c == 0) {
                c = o1.palette.getType().compareTo(o2.palette.getType());
            }
            return c;
        }
    }

    static abstract class Sort
    implements Comparator<ColorPaletteItem> {
        boolean descending;

        Sort(boolean descending) {
            this.descending = descending;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.descending ? 1 : 0;
        }
    }

    static class Biome
    extends ColorPaletteItem {
        private final List<Integer> colors;

        public Biome(ColorPalette palette, String biomeId, boolean underDefault, Font fontRenderer, ColorPaletteScreen screen) {
            super(palette, BiomeHelper.getTranslatedBiomeName(Identifier.parse((String)biomeId)), biomeId, underDefault, fontRenderer, screen);
            BiomeColor biomeColor = palette.getBiomeColor(biomeId);
            this.colors = List.of(Integer.valueOf(RGB.hexToInt(biomeColor.grassColor)), Integer.valueOf(RGB.hexToInt(biomeColor.fogColor)), Integer.valueOf(RGB.hexToInt(biomeColor.foliageColor)), Integer.valueOf(RGB.hexToInt(biomeColor.waterColor)));
        }

        @Override
        protected void copy() {
            this.screen.copyBiome(this.id, this.palette.getType() == ColorPalette.Type.Global);
        }

        @Override
        protected void removeFromPalette() {
            this.screen.removeBiomeFromPalette(this.id, this.palette.getType());
        }

        @Override
        protected void openColorPaletteItemEditor() {
            boolean saveToGlobal = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.Global;
            boolean saveToWorld = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.World;
            UIManager.INSTANCE.openColorPaletteBiomeEditor(this.id, this.palette.getBiomeColor(this.id), saveToGlobal, saveToWorld, this.screen);
        }

        @Override
        protected Collection<Integer> getColors() {
            return this.colors;
        }
    }

    static class Block
    extends ColorPaletteItem {
        private final Map<String, BlockStateColor> blockStatesToColor;
        private final List<Integer> colors;

        public Block(ColorPalette palette, String blockId, boolean underDefault, Font fontRenderer, ColorPaletteScreen screen) {
            super(palette, BlockMD.getBlockName((net.minecraft.world.level.block.Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(Identifier.parse((String)blockId)).get()).value()), blockId, underDefault, fontRenderer, screen);
            this.blockStatesToColor = palette.getAllStates(blockId);
            this.colors = this.blockStatesToColor.values().stream().map(bsc -> RGB.hexToInt(bsc.color)).toList();
        }

        @Override
        protected void copy() {
            this.screen.copyBlock(this.id, this.palette.getType() == ColorPalette.Type.Global);
        }

        @Override
        protected void removeFromPalette() {
            this.screen.removeBlockFromPalette(this.id, this.palette.getType());
        }

        @Override
        protected void openColorPaletteItemEditor() {
            boolean saveToGlobal = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.Global;
            boolean saveToWorld = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.World;
            UIManager.INSTANCE.openColorPaletteBlockEditor(this.id, this.blockStatesToColor, saveToGlobal, saveToWorld, this.screen);
        }

        @Override
        protected Collection<Integer> getColors() {
            return this.colors;
        }
    }
}

