/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.function.DoubleSupplier;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class UnscaledStringWidget
extends ColoredStringWidget {
    private final DoubleSupplier scaleFactorSupplier;
    private GuiGraphics graphics;

    public UnscaledStringWidget(int minWidth, int minHeight, Component message, Font font, DoubleSupplier scaleFactorSupplier) {
        super(minWidth, minHeight, message, font);
        this.scaleFactorSupplier = scaleFactorSupplier;
    }

    public int getWidth() {
        return Math.max(this.width, (int)Math.round((double)this.getFont().width((FormattedText)this.getMessage()) / this.scaleFactorSupplier.getAsDouble()));
    }

    public int getHeight() {
        return Math.max(this.height, (int)Math.round(9.0 / this.scaleFactorSupplier.getAsDouble()));
    }

    @Override
    public UnscaledStringWidget setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public Component getMessage() {
        return super.getMessage().copy().withStyle(style -> style.withColor(this.color));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double scale = 1.0 / this.scaleFactorSupplier.getAsDouble();
        DrawUtil.drawLabel(graphics, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, this.getColor(), this.alpha, scale, true);
    }
}

