/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.about;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.dialog.about.SplashHead;
import journeymap.client.ui.dialog.about.WhatsNew;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class AboutScreen
extends JmUI {
    private final LinearLayout persons = LinearLayout.horizontal();
    private Rectangle2D.Double screenBounds;
    private long lastPeopleMove;
    private final List<SplashHead> heads = Arrays.asList(new SplashHead("79f597fe-2877-4ecb-acdf-8c58cc1854ca", "mysticdrew", "jm.common.splash_developer"), new SplashHead("a2039b6c-5a3d-407d-b49c-091405062b85", "techbrew", "jm.common.splash_developer"), new SplashHead("1a07ce68-7eba-4609-909a-d6731a090138", "gdude2002", "jm.common.splash_developer"), new SplashHead("2414c36c-9f83-40a4-b0b6-6b2a88db6479", "MemeSapiens", "jm.common.splash_developer"), new SplashHead("16fd5b0e-a7a7-42a6-b203-52de6493c2b4", "Sandriell", "jm.common.splash_artist"), new SplashHead("cb87d53e-80a7-456a-804b-bfe2e4b0ae81", "Zxhir", "jm.common.splash_documentor"));

    public AboutScreen(Screen returnDisplay) {
        super(Constants.getString("jm.common.splash_title", Journeymap.JM_VERSION), true, returnDisplay);
        this.renderBackground = false;
    }

    @Override
    public void init() {
        JourneymapClient.getInstance().getCoreProperties().splashViewed.set(Journeymap.JM_VERSION.toString()).save();
        super.init();
        this.screenBounds = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        this.heads.forEach(head -> {
            this.persons.addChild((LayoutElement)head, LayoutSettings::alignHorizontallyCenter);
            head.randomizeVector();
        });
        this.persons.spacing(30);
        this.persons.arrangeElements();
        this.contentLayout.addChild((LayoutElement)new WhatsNew(this), LayoutSettings::alignVerticallyTop);
        this.contentLayout.addChild((LayoutElement)this.bottonButtonBuilder(), LayoutSettings::alignVerticallyBottom);
    }

    private LinearLayout bottonButtonBuilder() {
        LinearLayout bottomButtonsLayout = LinearLayout.vertical();
        bottomButtonsLayout.spacing(2);
        LinearLayout rowOneLayout = LinearLayout.horizontal();
        LinearLayout rowTwoLayout = LinearLayout.horizontal();
        LinearLayout rowThreeLayout = LinearLayout.horizontal();
        rowTwoLayout.spacing(2);
        rowThreeLayout.spacing(2);
        ((BasicImageButton)rowOneLayout.addChild((LayoutElement)new BasicImageButton(100, 20, new WidgetSprites(TextureCache.Discord, TextureCache.Discord), button -> FullscreenActions.discord(), (Component)Component.translatable((String)"jm.common.discord")))).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.common.discord.tooltip")));
        ((net.minecraft.client.gui.components.Button)rowTwoLayout.addChild((LayoutElement)net.minecraft.client.gui.components.Button.builder((Component)Component.literal((String)"http://journeymap.info"), button -> FullscreenActions.launchWebsite("")).build())).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.common.website")));
        ((net.minecraft.client.gui.components.Button)rowTwoLayout.addChild((LayoutElement)net.minecraft.client.gui.components.Button.builder((Component)Component.translatable((String)"jm.common.download"), button -> FullscreenActions.launchDownloadWebsite()).build())).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.common.download.tooltip")));
        rowThreeLayout.addChild((LayoutElement)net.minecraft.client.gui.components.Button.builder((Component)Component.translatable((String)"jm.common.options_button"), button -> {
            if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof ClientOptionsManager) {
                this.closeAndReturn();
            } else {
                UIManager.INSTANCE.openOptionsManager((Screen)this, new Category[0]);
            }
        }).build());
        rowThreeLayout.addChild((LayoutElement)net.minecraft.client.gui.components.Button.builder((Component)Component.translatable((String)"jm.common.close"), button -> super.closeAndReturn()).build());
        bottomButtonsLayout.addChild((LayoutElement)rowOneLayout, LayoutSettings::alignHorizontallyCenter);
        bottomButtonsLayout.addChild((LayoutElement)rowTwoLayout, LayoutSettings::alignHorizontallyCenter);
        this.footerLayout.addChild((LayoutElement)rowThreeLayout, LayoutSettings::alignHorizontallyCenter);
        return bottomButtonsLayout;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.width, 36.0, 0, 0.9f);
        DrawUtil.drawRectangle(graphics, 0.0, this.height - 30, this.width, this.height, 0, 0.6f);
        this.renderHeads(graphics, x, y, partialTicks);
        List<FormattedCharSequence> tooltip = null;
        for (Renderable renderable : this.getRenderables()) {
            Button button;
            renderable.render(graphics, x, y, partialTicks);
            if (tooltip != null || !(renderable instanceof Button) || !(button = (Button)renderable).mouseOver(x, y)) continue;
            tooltip = button.getWrappedTooltip();
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            this.renderWrappedToolTip(graphics, new PoseStack(), tooltip, x, y, this.getFontRenderer());
        }
    }

    private void renderHeads(GuiGraphics graphics, int x, int y, float partialTicks) {
        boolean movePeople;
        boolean bl = movePeople = System.currentTimeMillis() - this.lastPeopleMove > 1L;
        if (movePeople) {
            this.lastPeopleMove = System.currentTimeMillis();
        }
        this.persons.visitWidgets(widget -> widget.render(graphics, x, y, partialTicks));
        for (SplashHead head : this.heads) {
            if (head.isMouseOver(x, y)) {
                head.randomizeVector();
            }
            if (!movePeople) continue;
            head.avoid(this.heads);
            head.adjustVector(this.screenBounds);
        }
    }
}

