/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.api.plugins.LoadedChunkOverlayPlugin;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class ChunkOverlayPacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"chunk_overlay");
    public static final StreamCodec<RegistryFriendlyByteBuf, ChunkOverlayPacket> STREAM_CODEC = StreamCodec.ofMember(ChunkOverlayPacket::encode, ChunkOverlayPacket::new);
    private String payload;

    public ChunkOverlayPacket() {
    }

    public ChunkOverlayPacket(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public ChunkOverlayPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.payload = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for chunk overlay packet: %s", t));
        }
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.writeUtf(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for chunk overlay packet:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ChunkOverlayPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            LoadedChunkOverlayPlugin.getInstance().displayOverlay(((ChunkOverlayPacket)ctx.message()).payload);
        }
    }
}

