/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.common.Journeymap;
import journeymap.common.network.packets.HandshakePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class CommonPacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"common");
    public static final StreamCodec<RegistryFriendlyByteBuf, CommonPacket> STREAM_CODEC = StreamCodec.ofMember(CommonPacket::encode, CommonPacket::new);

    public CommonPacket() {
    }

    public CommonPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void handle(PacketContext<CommonPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> unknown";
            Journeymap.getLogger().warn(message);
            Minecraft.getInstance().player.connection.getConnection().disconnect((Component)Component.literal((String)message));
        } else {
            String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> unknown";
            Journeymap.getLogger().warn(message);
            HandshakePacket.disconnect(ctx.sender(), message);
        }
    }
}

