/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.util.CommonProxy;

public class LootTableMineableCollector {
    private static List<Block> shearableBlocks = List.of();
    private final HolderLookup.RegistryLookup<LootTable> lootRegistry;
    private final ItemStack toolItem;

    public LootTableMineableCollector(HolderLookup.RegistryLookup<LootTable> lootRegistry, ItemStack toolItem) {
        this.lootRegistry = lootRegistry;
        this.toolItem = toolItem;
    }

    public static List<Block> execute(HolderLookup.RegistryLookup<LootTable> lootRegistry, ItemStack toolItem) {
        Stopwatch stopwatch = null;
        if (CommonProxy.isDevEnv()) {
            stopwatch = Stopwatch.createStarted();
        }
        LootTableMineableCollector collector = new LootTableMineableCollector(lootRegistry, toolItem);
        ArrayList list = Lists.newArrayList();
        for (Block block : BuiltInRegistries.BLOCK) {
            LootTable lootTable;
            if (block.getLootTable().isEmpty() || !ShearsToolHandler.getInstance().test(block.defaultBlockState()).isEmpty() || !collector.doLootTable(lootTable = (LootTable)lootRegistry.get((ResourceKey)block.getLootTable().get()).map(Holder::value).orElse(null))) continue;
            list.add(block);
        }
        if (stopwatch != null) {
            Jade.LOGGER.info("LootTableMineableCollector took {}", (Object)stopwatch.stop());
        }
        return list;
    }

    private boolean doLootTable(@Nullable LootTable lootTable) {
        if (lootTable == null || lootTable == LootTable.EMPTY) {
            return false;
        }
        for (LootPool pool : lootTable.pools) {
            if (!this.doLootPool(pool)) continue;
            return true;
        }
        return false;
    }

    private boolean doLootPool(LootPool lootPool) {
        for (LootPoolEntryContainer entry : lootPool.entries) {
            if (!this.doLootPoolEntry(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean doLootPoolEntry(LootPoolEntryContainer entry) {
        if (entry instanceof AlternativesEntry) {
            AlternativesEntry alternativesEntry = (AlternativesEntry)entry;
            for (LootPoolEntryContainer child : alternativesEntry.children) {
                if (!this.doLootPoolEntry(child)) continue;
                return true;
            }
        } else {
            if (entry instanceof NestedLootTable) {
                NestedLootTable nestedLootTable = (NestedLootTable)entry;
                Optional lootTable = (Optional)nestedLootTable.contents.map($ -> this.lootRegistry.get($).map(Holder::value), Optional::of);
                return this.doLootTable(lootTable.orElse(null));
            }
            return CommonProxy.isCorrectConditions(entry.conditions, this.toolItem);
        }
        return false;
    }

    public static void onTagsUpdated(HolderLookup.Provider lookupProvider, boolean client) {
        try {
            shearableBlocks = LootTableMineableCollector.execute((HolderLookup.RegistryLookup<LootTable>)lookupProvider.lookupOrThrow(Registries.LOOT_TABLE), Items.SHEARS.getDefaultInstance());
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Failed to collect shearable blocks", e);
        }
    }

    public static List<Block> getShearableBlocks() {
        return shearableBlocks;
    }
}

