/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ClientProxy;

public class TotalEnchantmentPowerProvider
implements IBlockComponentProvider {
    public static final TotalEnchantmentPowerProvider INSTANCE = new TotalEnchantmentPowerProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Level world = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        float power = 0.0f;
        for (BlockPos blockpos : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (!EnchantingTableBlock.isValidBookShelf((Level)world, (BlockPos)pos, (BlockPos)blockpos)) continue;
            power += TotalEnchantmentPowerProvider.getPower(world, pos.offset((Vec3i)blockpos));
        }
        if (power > 0.0f) {
            tooltip.add((Component)Component.translatable((String)"jade.ench_power", (Object[])new Object[]{IThemeHelper.get().info(DisplayHelper.dfCommas.format(power))}));
        }
    }

    public static float getPower(Level world, BlockPos pos) {
        return ClientProxy.getEnchantPowerBonus(world.getBlockState(pos), world, pos);
    }

    @Override
    public Identifier getUid() {
        return JadeIds.MC_TOTAL_ENCHANTMENT_POWER;
    }

    @Override
    public int getDefaultPriority() {
        return -400;
    }
}

