/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.config;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.ClipContext;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.JadeInternals;
import snownee.jade.api.SimpleStringRepresentable;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.Theme;

@ApiStatus.NonExtendable
public interface IWailaConfig {
    public static IWailaConfig get() {
        return JadeInternals.getWailaConfig();
    }

    public General general();

    public Overlay overlay();

    public Formatting formatting();

    public Accessibility accessibility();

    public IPluginConfig plugin();

    public void save();

    public void invalidate();

    public String getName();

    public void setName(String var1);

    @ApiStatus.NonExtendable
    public static interface Accessibility {
        public boolean shouldEnableTextToSpeech();

        public void toggleTTS();

        public TTSMode getTTSMode();

        public void setTTSMode(TTSMode var1);

        public boolean getEnableAccessibilityPlugin();

        public void setEnableAccessibilityPlugin(boolean var1);

        public boolean getFlipMainHand();

        public void setFlipMainHand(boolean var1);

        public float tryFlip(float var1);

        public void setTextBackgroundOpacity(float var1);

        public float getTextBackgroundOpacity();

        public void setNarrateKeys(boolean var1);

        public boolean getNarrateKeys();
    }

    @ApiStatus.NonExtendable
    public static interface Formatting {
        public Style getItemModNameStyle();

        public void setItemModNameStyle(Style var1);

        public Component registryName(String var1);
    }

    @ApiStatus.NonExtendable
    public static interface Overlay {
        public static int applyAlpha(int color, float alpha) {
            if (alpha == 1.0f) {
                return color;
            }
            if (alpha == 0.0f) {
                return 0;
            }
            int prevAlpha = ARGB.alpha((int)color);
            if (prevAlpha != 255) {
                alpha *= (float)prevAlpha / 255.0f;
            }
            return ARGB.color((int)ARGB.as8BitChannel((float)alpha), (int)color);
        }

        public float getOverlayPosX();

        public void setOverlayPosX(float var1);

        public float getOverlayPosY();

        public void setOverlayPosY(float var1);

        public float getOverlayScale();

        public void setOverlayScale(float var1);

        public float getAnchorX();

        public void setAnchorX(float var1);

        public float getAnchorY();

        public void setAnchorY(float var1);

        public float getAutoScaleThreshold();

        public float getAlpha();

        public void setAlpha(float var1);

        public Theme getTheme();

        public void applyTheme(Identifier var1);

        public boolean shouldShowIcon();

        public IconMode getIconMode();

        public void setIconMode(IconMode var1);

        public boolean getAnimation();

        public void setAnimation(boolean var1);

        public float getDisappearingDelay();

        public void setDisappearingDelay(float var1);
    }

    @ApiStatus.NonExtendable
    public static interface General {
        public void setDisplayTooltip(boolean var1);

        public boolean getDisplayEntities();

        public void setDisplayEntities(boolean var1);

        public boolean getDisplayBosses();

        public void setDisplayBosses(boolean var1);

        public boolean getDisplayBlocks();

        public void setDisplayBlocks(boolean var1);

        public void setHideFromTabList(boolean var1);

        public void setHideFromGUIs(boolean var1);

        public void setItemModNameTooltip(boolean var1);

        public boolean shouldDisplayTooltip();

        public DisplayMode getDisplayMode();

        public void setDisplayMode(DisplayMode var1);

        public boolean shouldHideFromTabList();

        public boolean shouldHideFromGUIs();

        public boolean shouldDisplayFluids();

        public FluidMode getDisplayFluids();

        public void setDisplayFluids(boolean var1);

        public void setDisplayFluids(FluidMode var1);

        public boolean showItemModNameTooltip();

        public float getExtendedReach();

        public void setExtendedReach(float var1);

        public BossBarOverlapMode getBossBarOverlapMode();

        public void setBossBarOverlapMode(BossBarOverlapMode var1);

        public boolean isDebug();

        public void setDebug(boolean var1);

        public boolean getBuiltinCamouflage();

        public void setBuiltinCamouflage(boolean var1);

        public PerspectiveMode getPerspectiveMode();

        public void setPerspectiveMode(PerspectiveMode var1);
    }

    public static enum HandlerDisplayStyle implements SimpleStringRepresentable
    {
        PROGRESS_BAR,
        ICON,
        PLAIN_TEXT;

    }

    public static enum PerspectiveMode implements SimpleStringRepresentable
    {
        CAMERA,
        EYE;

    }

    public static enum BossBarOverlapMode implements SimpleStringRepresentable
    {
        NO_OPERATION,
        HIDE_BOSS_BAR,
        HIDE_TOOLTIP,
        PUSH_DOWN;

    }

    public static enum FluidMode implements SimpleStringRepresentable
    {
        NONE(ClipContext.Fluid.NONE),
        ANY(ClipContext.Fluid.ANY),
        FALLBACK(ClipContext.Fluid.NONE);

        public final ClipContext.Fluid ctx;

        private FluidMode(ClipContext.Fluid ctx) {
            this.ctx = ctx;
        }
    }

    public static enum DisplayMode implements SimpleStringRepresentable
    {
        HOLD_KEY,
        TOGGLE,
        LITE;

    }

    public static enum TTSMode implements SimpleStringRepresentable
    {
        TOGGLE,
        PRESS;

    }

    public static enum IconMode implements SimpleStringRepresentable
    {
        TOP,
        CENTERED,
        INLINE,
        HIDE;

    }
}

