/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jspecify.annotations.Nullable;

public class NarratableComponent
implements Component {
    private final Component component;
    private final @Nullable Supplier<String> narration;

    public NarratableComponent(Component component) {
        this(component, null);
    }

    public NarratableComponent(Component component, @Nullable Supplier<String> narration) {
        this.component = component;
        this.narration = narration;
    }

    public Style getStyle() {
        return this.component.getStyle();
    }

    public ComponentContents getContents() {
        return this.component.getContents();
    }

    public List<Component> getSiblings() {
        return this.component.getSiblings();
    }

    public FormattedCharSequence getVisualOrderText() {
        return this.component.getVisualOrderText();
    }

    public String toString() {
        return this.component.getString();
    }

    public String getNarration() {
        return this.narration != null ? this.narration.get() : this.component.getString();
    }

    public static Component getNarration(FormattedText text) {
        if (text instanceof NarratableComponent) {
            NarratableComponent narratable = (NarratableComponent)text;
            return Component.literal((String)narratable.getNarration());
        }
        if (text instanceof Component) {
            Component component = (Component)text;
            return component;
        }
        return Component.literal((String)text.getString());
    }

    public static Component attach(Component component, Component narratable) {
        if (narratable instanceof NarratableComponent) {
            NarratableComponent narratableComponent = (NarratableComponent)narratable;
            return new NarratableComponent(component, narratableComponent.narration);
        }
        return new NarratableComponent(component, () -> ((Component)narratable).getString());
    }

    public static Component translatable(String key, Object ... objects) {
        boolean hasNarratable = false;
        for (Object object : objects) {
            if (!(object instanceof NarratableComponent)) continue;
            hasNarratable = true;
            break;
        }
        MutableComponent component = Component.translatable((String)key, (Object[])objects);
        if (!hasNarratable) {
            return component;
        }
        Object[] narrationArgs = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof NarratableComponent) {
                NarratableComponent narratable = (NarratableComponent)object;
                narrationArgs[i] = narratable.getNarration();
                continue;
            }
            narrationArgs[i] = objects[i];
        }
        return new NarratableComponent((Component)component, () -> Component.translatable((String)key, (Object[])narrationArgs).getString());
    }
}

