/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.ProgressStyle;

public class ProgressView {
    public List<Part> parts = List.of();
    public final ProgressStyle style;
    public final BoxStyle boxStyle;
    public @Nullable Component text;

    public ProgressView(ProgressStyle style, BoxStyle boxStyle) {
        this.style = Objects.requireNonNull(style);
        this.boxStyle = Objects.requireNonNull(boxStyle);
    }

    public <T> ProgressView(ProgressStyle style, BoxStyle boxStyle, Stream<T> items, Function<T, Part> mapper) {
        this(style, boxStyle);
        this.parts = items.map(mapper).toList();
    }

    public ProgressView(Part progress, @Nullable Component text, ProgressStyle style, BoxStyle boxStyle) {
        this(List.of(progress), text, style, boxStyle);
    }

    public ProgressView(List<Part> progress, @Nullable Component text, ProgressStyle style, BoxStyle boxStyle) {
        this(style, boxStyle);
        this.parts = Objects.requireNonNull(progress);
        this.text = text;
    }

    public static ProgressView read(Data data) {
        ProgressView view = new ProgressView(JadeUI.progressStyle(), BoxStyle.nestedBox());
        if (data.progress > 0.0f) {
            view.parts = List.of(Part.of(data.progress, data.messageType));
        }
        return view;
    }

    public record Data(float progress, float speed, float target, MessageType messageType) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Data::progress, (StreamCodec)ByteBufCodecs.FLOAT, Data::speed, (StreamCodec)ByteBufCodecs.FLOAT, Data::target, MessageType.STREAM_CODEC, Data::messageType, Data::new);

        public Data(float progress) {
            this(progress, MessageType.INFO);
        }

        public Data(float progress, float speed, float target) {
            this(progress, speed, target, MessageType.INFO);
        }

        public Data(float progress, MessageType messageType) {
            this(progress, Float.NaN, Float.NaN, messageType);
        }
    }

    public record Part(int id, float progress, float speed, float target, @Nullable Element overlay, @Nullable MessageType messageType, int color) {
        public Part(int id, float progress, float speed, float target, @Nullable Element overlay, @Nullable MessageType messageType, int color) {
            this.id = id;
            this.progress = progress;
            this.speed = speed;
            this.target = target;
            this.overlay = overlay;
            this.messageType = messageType;
            this.color = color;
            Preconditions.checkArgument((progress >= 0.0f && progress <= 1.0f ? 1 : 0) != 0, (String)"Progress must be between 0 and 1, got: %s", (Object)Float.valueOf(progress));
        }

        public Part(int id, float progress, @Nullable Element overlay, @Nullable MessageType messageType, int color) {
            this(id, progress, Float.NaN, Float.NaN, overlay, messageType, color);
        }

        public static Part of(float progress) {
            return Part.of(0, progress);
        }

        public static Part of(int id, float progress) {
            return Part.of(id, progress, MessageType.INFO);
        }

        public static Part of(float progress, MessageType messageType) {
            return Part.of(0, progress, messageType);
        }

        public static Part of(int id, float progress, MessageType messageType) {
            return new Part(id, progress, null, messageType, -1);
        }

        public static Part of(float progress, Element overlay) {
            return new Part(0, progress, overlay, null, -1);
        }

        public static Part of(float progress, int color) {
            return new Part(0, progress, null, null, color);
        }

        public int themeColor() {
            if (this.color != -1) {
                return this.color;
            }
            if (this.messageType != null) {
                return IThemeHelper.get().theme().progressColors.get(this.messageType);
            }
            return -1;
        }
    }

    public static class PartBuilder {
        int id;
        float progress;
        float speed;
        float target;
        @Nullable Element overlay;
        @Nullable MessageType messageType;
        int color = -1;

        public PartBuilder id(int id) {
            this.id = id;
            return this;
        }

        public PartBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        public PartBuilder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public PartBuilder target(float target) {
            this.target = target;
            return this;
        }

        public PartBuilder overlay(Element overlay) {
            this.overlay = overlay;
            return this;
        }

        public PartBuilder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public PartBuilder color(int color) {
            this.color = color;
            return this;
        }

        public Part build() {
            return new Part(this.id, this.progress, this.speed, this.target, this.overlay, this.messageType, this.color);
        }
    }
}

