/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.JadeUIInternal;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorClientHandler
implements AccessorClientHandler<BlockAccessor> {
    @Override
    public boolean shouldDisplay(BlockAccessor accessor) {
        return IWailaConfig.get().general().getDisplayBlocks();
    }

    @Override
    public List<IServerDataProvider<BlockAccessor>> shouldRequestData(BlockAccessor accessor) {
        List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.instance().blockDataProvidersOf(accessor.getBlockState(), accessor.getBlockEntity(), !accessor.isServersideContent());
        if (providers.isEmpty()) {
            return List.of();
        }
        return providers.stream().filter(provider -> {
            try {
                return provider.shouldRequestData(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                return false;
            }
        }).toList();
    }

    @Override
    public void requestData(BlockAccessor accessor, List<IServerDataProvider<BlockAccessor>> providers) {
        ClientProxy.sendPacket(new RequestBlockPacket(new BlockAccessorImpl.SyncData(accessor), providers));
    }

    @Override
    public @Nullable Element getIcon(BlockAccessor accessor) {
        BlockState blockState = accessor.getBlockState();
        Block block = blockState.getBlock();
        if (blockState.isAir()) {
            return null;
        }
        Element icon = null;
        ItemStack pick = accessor.getPickedResult();
        if (!pick.isEmpty()) {
            icon = JadeUI.item(pick);
        }
        if (JadeUI.isEmptyElement(icon) && block.asItem() != Items.AIR) {
            icon = JadeUI.item(new ItemStack((ItemLike)block));
        }
        if (JadeUI.isEmptyElement(icon) && block instanceof LiquidBlock) {
            icon = ClientProxy.elementFromLiquid(blockState);
        }
        for (IComponentProvider<BlockAccessor> provider : WailaClientRegistration.instance().getBlockIconProviders(block, this::isEnabled)) {
            try {
                Element element = provider.getIcon(accessor, IWailaConfig.get().plugin(), icon);
                if (JadeUI.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherComponents(BlockAccessor accessor, Function<IJadeProvider, ITooltip> tooltipProvider) {
        for (IComponentProvider<BlockAccessor> provider : WailaClientRegistration.instance().getBlockProviders(accessor.getBlock(), this::isEnabled)) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                JadeUIInternal.setContextUid(provider.getUid());
                provider.appendTooltip(tooltip, accessor, IWailaConfig.get().plugin());
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            }
            finally {
                JadeUIInternal.setContextUid(null);
            }
        }
    }
}

