/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.overlay.DisplayHelper;

public class HorizontalLineElement
extends ResizeableElement {
    public int color = IThemeHelper.get().getNormalColor();

    public HorizontalLineElement() {
        this.width = 10;
        this.height = 4;
    }

    @Override
    public @Nullable Component getNarration() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getX();
        int y = this.getY() + this.height / 2;
        Theme theme = IThemeHelper.get().theme();
        if (theme.text.shadow() && !theme.lightColorScheme) {
            Color shadow = Color.rgb(this.color);
            shadow = Color.rgb(shadow.getRed() / 4, shadow.getGreen() / 4, shadow.getBlue() / 4, shadow.getOpacity());
            DisplayHelper.fill(graphics, (float)x + 2.5f, (float)y + 0.5f, (float)(x + this.width) - 1.5f, (float)y + 1.0f, shadow.toInt());
        }
        DisplayHelper.fill(graphics, x + 2, y, x + this.width - 2, (float)y + 0.5f, this.color);
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.width = width;
    }
}

