/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.joml.Matrix3x2fStack;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.api.ui.TextElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeLanguages;

public class TextElementImpl
extends TextElement {
    protected final Component text;
    protected float scale = 1.0f;
    protected float alpha = 1.0f;
    private int textWidth;

    public TextElementImpl(Component text) {
        this.text = text;
        this.width = this.textWidth = Math.max(DisplayHelper.font().width((FormattedText)text), 0);
        Objects.requireNonNull(DisplayHelper.font());
        this.height = 9 - 1;
    }

    @Override
    public TextElement scale(float scale) {
        this.scale = scale;
        this.width = Math.max(Math.round((float)DisplayHelper.font().width((FormattedText)this.text) * scale), 0);
        Objects.requireNonNull(DisplayHelper.font());
        this.height = Math.round(9.0f * scale) - 1;
        return this;
    }

    @Override
    public TextElement alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.textLeft();
        int normalColor = IWailaConfig.Overlay.applyAlpha(IThemeHelper.get().getNormalColor(), this.alpha);
        boolean scaled = this.scale != 1.0f;
        Matrix3x2fStack matrixStack = graphics.pose();
        if (scaled) {
            matrixStack.pushMatrix();
            matrixStack.translate((float)x, (float)this.getY() + this.scale);
            matrixStack.scale(this.scale);
            DisplayHelper.INSTANCE.drawText(graphics, (FormattedText)this.text, 0.0f, 0.0f, normalColor);
        } else {
            DisplayHelper.INSTANCE.drawText(graphics, (FormattedText)this.text, (float)x, (float)this.getY(), normalColor);
        }
        if (mouseX != -1 && this.getRectangle().containsPoint(mouseX, mouseY)) {
            ActiveTextCollector collector = graphics.textRenderer(GuiGraphics.HoveredTextEffects.TOOLTIP_AND_CURSOR);
            this.textCollector(collector);
        }
        if (scaled) {
            matrixStack.popMatrix();
        }
    }

    @Override
    public Component getNarration() {
        return NarratableComponent.getNarration((FormattedText)this.text);
    }

    public String getString() {
        return this.text.getString();
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen != null) {
            ActiveTextCollector.ClickableStyleFinder collector = new ActiveTextCollector.ClickableStyleFinder(mc.font, (int)event.x(), (int)event.y());
            this.textCollector((ActiveTextCollector)collector);
            Style style = collector.result();
            if (style != null && style.getClickEvent() != null) {
                Screen.defaultHandleGameClickEvent((ClickEvent)style.getClickEvent(), (Minecraft)mc, (Screen)screen);
                return true;
            }
        }
        return false;
    }

    private void textCollector(ActiveTextCollector collector) {
        int x = this.textLeft();
        int y = this.getY();
        if (this.scale != 1.0f) {
            y = 0;
            x = 0;
        }
        collector.defaultParameters(collector.defaultParameters().withOpacity(0.0f));
        collector.accept(x, y, this.text);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.textLeft() && mouseX < (double)(this.textLeft() + this.textWidth) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
    }

    private int textLeft() {
        int x = this.getX();
        if (JadeLanguages.INSTANCE.isRTL()) {
            x += this.width - this.textWidth;
        }
        return x;
    }
}

