/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.track;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.Identifier;
import snownee.jade.track.TrackInfo;

public class ProgressTracker {
    private final ListMultimap<Identifier, TrackInfo> map = ArrayListMultimap.create();

    public <T extends TrackInfo> T getOrCreate(Identifier tag, Class<T> type, Supplier<T> supplier) {
        List infos = this.map.get((Object)tag);
        TrackInfo info = null;
        for (TrackInfo o : infos) {
            if (o.updatedThisTick || !type.isInstance(o)) continue;
            info = (TrackInfo)type.cast(o);
            break;
        }
        if (info == null) {
            info = (TrackInfo)supplier.get();
            this.map.put((Object)tag, (Object)info);
        }
        info.updatedThisTick = true;
        return (T)info;
    }

    public void tick() {
        if (this.map.isEmpty()) {
            return;
        }
        this.map.values().removeIf(info -> {
            if (info.updatedThisTick && info.alive) {
                info.tick();
                info.updatedThisTick = false;
                return false;
            }
            return true;
        });
    }

    public void clear() {
        this.map.clear();
    }
}

